/* $Id: mode.c,v 1.17 1998/12/18 21:36:22 marcus Exp $
******************************************************************************

   Graphics library for GGI. Mode management.

   Copyright (C) 1997 Jason McMullan [jmcc@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/xlib.h>

static void GGI_Xlib_gcchanged(ggi_visual *vis, int mask)
{
	if ((mask & GGI_GCCHANGED_CLIP)) {
		XRectangle xrect;
		xrect.x = LIBGGI_GC(vis)->cliptl.x;
		xrect.y = LIBGGI_GC(vis)->cliptl.y;
		xrect.width 
			= LIBGGI_GC(vis)->clipbr.x-LIBGGI_GC(vis)->cliptl.x;
		xrect.height 
			= LIBGGI_GC(vis)->clipbr.y-LIBGGI_GC(vis)->cliptl.y;
		XSetClipRectangles(XLIB_PRIV(vis)->display, XLIB_PRIV(vis)->gc,
				   0, 0, &xrect, 1, Unsorted);
		XSetClipRectangles(XLIB_PRIV(vis)->display, 
				   XLIB_PRIV(vis)->tempgc,
				   0, 0, &xrect, 1, Unsorted);
	}
	if ((mask & GGI_GCCHANGED_FG)) {
		XSetForeground(XLIB_PRIV(vis)->display, XLIB_PRIV(vis)->gc,
			       LIBGGI_GC(vis)->fg_color);
	}
	if ((mask & GGI_GCCHANGED_BG)) {
		XSetBackground(XLIB_PRIV(vis)->display, XLIB_PRIV(vis)->gc,
			       LIBGGI_GC(vis)->fg_color);
	}
}

int GGI_Xlib_flush(ggi_visual *vis, int tryflag)
{
	struct Xhooks *xhook=(struct Xhooks *)LIBGGI_PRIVATE(vis);
	
	ggLock(xhook->XLibLock);

	if (xhook->cmap && xhook->cmap_first<xhook->cmap_last) {
		int x;
		XColor xcol;
		for(x=xhook->cmap_first;x<xhook->cmap_last;x++)	{
			xcol.red  =vis->palette[x].r;
			xcol.green=vis->palette[x].g;
			xcol.blue =vis->palette[x].b;
			xcol.pixel=x;
			xcol.flags= DoRed | DoGreen | DoBlue ;
			XStoreColor(xhook->display, xhook->cmap,&xcol);
		}
		xhook->cmap_first=256;
		xhook->cmap_last=0;
		XSetWindowColormap(xhook->display, xhook->window, xhook->cmap);
	}
	
	XFlush(xhook->display);

	ggUnlock(xhook->XLibLock);
	
	return 0;
}

/*************************/
/* set the current flags */
/*************************/
int GGI_Xlib_setflags(ggi_visual *vis,ggi_flags flags)
{
	LIBGGI_FLAGS(vis)=flags;
	return 0;
}

#define GGI_X_flush	GGI_Xlib_flush
#define GGI_X_getmode	GGI_Xlib_getmode
#define GGI_X_setmode	GGI_Xlib_setmode
#define GGI_X_checkmode	GGI_Xlib_checkmode
#define GGI_X_getapi	GGI_Xlib_getapi
#define GGI_X_setpalvec	GGI_Xlib_setpalvec

#define GGI_XLIB_TARGET
#include "../X_common/mode.inc"
