/* $Id: hline.c,v 1.10 1998/11/19 01:06:28 marcus Exp $
******************************************************************************

   Graphics library for GGI. Horizontal lines.

   Copyright (C) 1995 Andreas Beck [becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <string.h>

#include "lin8lib.h"

/**********************************/
/* draw/get/put a horizontal line */
/**********************************/

int GGI_lin8_drawhline(ggi_visual *vis,int x,int y,int w)
{
	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w>0) {
		memset((char *)LIBGGI_CURWRITE(vis)
		       + y*LIBGGI_FB_W_STRIDE(vis)+x,
		       LIBGGI_GC_FGCOLOR(vis),w);
	}
	return 0;
}

int GGI_lin8_drawhline_nc(ggi_visual *vis,int x,int y,int w)
{
        memset((char *)LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+x,
	       LIBGGI_GC_FGCOLOR(vis),w);
	return 0;
}

int GGI_lin8_puthline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	char *mem;

	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
		buffer=((char *)buffer)+diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w>0) {
		mem=(char *)LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+x;
		memcpy(mem,buffer,w);
	}
	return 0;
}

int GGI_lin8_gethline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	memcpy(buffer,(char *)LIBGGI_CURREAD(vis)+y*LIBGGI_FB_R_STRIDE(vis)+x,w);

	return 0;
}

