/* $Id: vline.c,v 1.10 1998/11/19 01:06:28 marcus Exp $
******************************************************************************

   Graphics library for GGI.

   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "lin4lib.h"

/********************************/
/* draw/get/put a vertical line */
/********************************/
int GGI_lin4_drawvline(ggi_visual *vis,int x,int y,int height)
{
	uint8 *ptr;
	int w=LIBGGI_FB_W_STRIDE(vis);
	uint8 shift = (x & 0x01) << 2;
	uint8 color=LIBGGI_GC_FGCOLOR(vis) >> (shift^4);
	uint8 mask = 0x0f << shift;
	
	CHECKXYH(vis,x,y,height);

	ptr=(uint8 *)LIBGGI_CURWRITE(vis)+y*((w+x)>>1);

	for(;height>0;height--,ptr+=w) 
		*ptr=color | (*ptr & mask); 
	
	return 0;
}

int GGI_lin4_drawvline_nc(ggi_visual *vis,int x,int y,int height)
{
	uint8 *ptr;
	int w=LIBGGI_FB_W_STRIDE(vis);
	uint8 shift = (x & 0x01) << 2;
	uint8 color=LIBGGI_GC_FGCOLOR(vis) >> (shift^4);
	uint8 mask = 0x0f << shift;
	
	ptr=(uint8 *)LIBGGI_CURWRITE(vis)+y*((w+x)>>1);

	for(;height>0;height--,ptr+=w) 
		*ptr=color | (*ptr & mask); 
	
	return 0;
}

int GGI_lin4_putvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	uint8 *ptr,*pixels=(uint8 *)buffer;
	int w=LIBGGI_FB_W_STRIDE(vis);
	uint8 shift = (x & 0x01) << 2;
	uint8 mask = 0x0f << shift;
	uint8 antishift = shift ^ 4;
	
	CHECKXYH(vis,x,y,height);

	ptr=(uint8 *)LIBGGI_CURWRITE(vis)+y*((w+x)>>1);

	for(; height > 1; height-=2, ptr+=(w<<1)) {
		*ptr=(*pixels >> shift) | (*ptr & mask);
		*(ptr+w) = (*(pixels++) << antishift) | (*(ptr+w) & mask);
	}
	
	if (height) {
		*ptr=(*pixels >> shift) | (*ptr & mask);
	}
		
	return 0;
}

int GGI_lin4_getvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	uint8 *ptr,*pixels=(uint8 *)buffer;
	int w=LIBGGI_FB_W_STRIDE(vis);
	uint8 shift = (x & 0x01) << 2;
	uint8 mask = 0x0f << shift;
	uint8 antishift = shift ^ 4;
	
	ptr=(uint8 *)LIBGGI_CURREAD(vis)+y*((w+x)>>1);

	/* Warning: unnecessary bit operations ahead! */
	for (; height > 1; height-=2, ptr+=w<<1) {
		*pixels = ((*ptr & mask) << shift) | ((*(ptr+w) & mask) >> antishift);
	}
	
	/* Here we can't lazily stick the extra pixel into the buffer, since
	 * it might be off the screen. */
	if (height) {
		*pixels = ((*ptr & mask) << shift);
	}
	
	return 0;
}
