/* $Id: visual.c,v 1.15 1998/12/09 04:27:27 marcus Exp $
******************************************************************************

   Graphics library for GGI.

   Copyright (C) 1997 Jim Ursetto   [murasaki@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "lin4lib.h"

int GGIdlinit(ggi_visual *visual,const char *version,void *argptr)
{
	/* Color mapping 
	 */
	visual->opcolor->mapcolor=GGI_lin4_mapcolor;
	visual->opcolor->unmappixel=GGI_lin4_unmappixel;
	visual->opcolor->packcolors=GGI_lin4_packcolors;
	visual->opcolor->unpackpixels=GGI_lin4_unpackpixels;

	/* Frame handling
	 */

	visual->opdraw->setreadframe = _ggi_default_setreadframe;
	visual->opdraw->setwriteframe = _ggi_default_setwriteframe;
	
	/* Generic drawing
	 */
	visual->opdraw->drawpixel_nc=GGI_lin4_drawpixel_nc;
	visual->opdraw->drawpixel=GGI_lin4_drawpixel;
	visual->opdraw->putpixel_nc=GGI_lin4_putpixel_nc;
	visual->opdraw->putpixel=GGI_lin4_putpixel;
	visual->opdraw->getpixel=GGI_lin4_getpixel;

	visual->opdraw->drawhline_nc=GGI_lin4_drawhline_nc;
	visual->opdraw->drawhline=GGI_lin4_drawhline;
	visual->opdraw->puthline=GGI_lin4_puthline;
	visual->opdraw->gethline=GGI_lin4_gethline;

	visual->opdraw->drawvline_nc=GGI_lin4_drawvline_nc;
	visual->opdraw->drawvline=GGI_lin4_drawvline;
	visual->opdraw->putvline=GGI_lin4_putvline;
	visual->opdraw->getvline=GGI_lin4_getvline;

	visual->opdraw->copybox=GGI_lin4_copybox;

	return GGI_DL_OPCOLOR|GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *visual)
{
	return 0;
}

#include <ggi/internal/ggidlinit.h>
