/* $Id: hline.c,v 1.8 1998/11/19 01:06:28 marcus Exp $
******************************************************************************

   Graphics library for GGI. Horizontal lines.

   Copyright (C) 1995 Andreas Beck [becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <string.h>

#include <ggi/internal/ggi-dl.h>

/**********************************/
/* draw/get/put a horizontal line */
/**********************************/

int GGIdrawhline(ggi_visual *vis,int x,int y,int w)
{
	uint32 colors[3],*bla,i;
	uint8 *colp =(uint8 *)colors, *foo;
	
	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w<=0) return 0;

	foo=(uint8 *)LIBGGI_CURWRITE(vis)+
		(y*LIBGGI_FB_W_STRIDE(vis)+x*3);
	while(((x)&3)&&w)
	{  
		*foo++=(LIBGGI_GC_FGCOLOR(vis));
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>8);
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>16);
		x++;w--;
	};
	for (i=0;i<4;i++) 
	{
		*colp++=(LIBGGI_GC_FGCOLOR(vis));
		*colp++=(LIBGGI_GC_FGCOLOR(vis)>>8);
		*colp++=(LIBGGI_GC_FGCOLOR(vis)>>16);
	}
	bla=(uint32 *)foo;
	while (w>3) {
		*bla++=colors[0];
		*bla++=colors[1];
		*bla++=colors[2];
		w-=4;
	};
	foo=(uint8 *)bla;
	while (w) {
		*foo++=(LIBGGI_GC_FGCOLOR(vis));
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>8);
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>16);
		w--;
	};
	return 0;
}

int GGIdrawhline_nc(ggi_visual *vis,int x,int y,int w)
{
	uint32 colors[3],*bla,i;
	uint8 *colp =(uint8 *)colors, *foo;
	
	foo=(uint8 *)LIBGGI_CURWRITE(vis)+
		(y*LIBGGI_FB_W_STRIDE(vis)+x*3);
	while(((x)&3)&&w)
	{  
		*foo++=(LIBGGI_GC_FGCOLOR(vis));
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>8);
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>16);
		x++;w--;
	};
	for (i=0;i<4;i++) 
	{
		*colp++=(LIBGGI_GC_FGCOLOR(vis));
		*colp++=(LIBGGI_GC_FGCOLOR(vis)>>8);
		*colp++=(LIBGGI_GC_FGCOLOR(vis)>>16);
	}
	bla=(uint32 *)foo;
	while (w>3) {
		*bla++=colors[0];
		*bla++=colors[1];
		*bla++=colors[2];
		w-=4;
	};
	foo=(uint8 *)bla;
	while (w) {
		*foo++=(LIBGGI_GC_FGCOLOR(vis));
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>8);
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>16);
		w--;
	};
	return 0;
}

int GGIputhline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	CHECKXYW(vis,x,y,w);

	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
		buffer=((char *)buffer)+3*diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w>0) {
		memcpy((uint8 *)LIBGGI_CURWRITE(vis)+
		       (y*LIBGGI_FB_W_STRIDE(vis)+x*3),buffer,w*3);
	}
	return 0;
}

int GGIgethline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	memcpy(buffer,(uint8 *)LIBGGI_CURREAD(vis)+
	       (y*LIBGGI_FB_R_STRIDE(vis)+x*3),w*3);

	return 0;
}
