/* $Id: visual.c,v 1.3 1998/11/19 01:06:28 marcus Exp $
******************************************************************************

   LibGGI - kgicon specific overrides for fbcon
   Initialization

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdlib.h>
#include "genkgi.h"


static int refcount = 0;
int _ggi_genkgi_prividx = -1;

int GGIdlinit(ggi_visual *vis, const char *version, void *argptr)
{
	int idx = -1;
	struct genkgi_priv *priv;
	
	if (refcount == 0) {
		idx = _ggi_alloc_drvpriv();
		if (idx < 0) {
			return GGI_DL_ERROR;
		}
		_ggi_genkgi_prividx = idx;
	}
	
	priv = _ggi_malloc(sizeof(struct genkgi_priv));

	priv->fd = LIBGGI_FD(vis);
		
	if ((priv->mapped_gc = (ggi_gc *) mmap(NULL, 4096,
					       PROT_READ|PROT_WRITE,
					       MAP_SHARED, priv->fd,
					       MMAP_TYPE_GC))
	    == (void *)-1) {
		/* Can't mmap() GC - assume we are not on a KGI driver */
		free(priv);
		if (idx > -1) {
			_ggi_free_drvpriv(idx);
		}
		return GGI_DL_ERROR;
	}
	
	LIBGGI_GC(vis) = priv->mapped_gc;
	refcount++;
	
	priv->drawline = vis->opdraw->drawline;
	priv->drawbox = vis->opdraw->drawbox;
	priv->copybox = vis->opdraw->copybox;
	priv->fillscreen = vis->opdraw->fillscreen;
	
	vis->opdraw->drawline = GGI_genkgi_drawline;
	vis->opdraw->drawbox = GGI_genkgi_drawbox;
	vis->opdraw->copybox = GGI_genkgi_copybox;
	vis->opdraw->fillscreen = GGI_genkgi_fillscreen;

	LIBGGI_DRVPRIV(vis, _ggi_genkgi_prividx) = priv;

	return GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *vis)
{
	munmap((void*) GENKGI_PRIV(vis)->mapped_gc, 4096);
	
	free(GENKGI_PRIV(vis));
		
	refcount--;
	if (refcount == 0) {
		_ggi_free_drvpriv(_ggi_genkgi_prividx);
		_ggi_genkgi_prividx = -1;
	}
                
	return 0;
}
		
#include <ggi/internal/ggidlinit.h>
