/* $Id: color.c,v 1.7 1998/11/19 01:06:28 marcus Exp $
******************************************************************************

   Generic color mapping

   Copyright (C) 1998 Andrew Apted  [andrew@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <string.h>
#include "color.h"


#define DOSHIFT(val, shift)  \
	(((shift) >= 0) ? (val) << (shift) : (val) >> -(shift))


int GGI_color_getpalvec(ggi_visual *vis, int start, int len, ggi_color *colmap)
{
	int nocols = 256;
	
	if (vis->palette == NULL)
		return -1;

	if (GT_SCHEME(LIBGGI_GT(vis)) != GT_TRUECOLOR) {
		nocols = 1 << GT_DEPTH(LIBGGI_GT(vis));
	}

	if ((colmap == NULL) || (start < 0) || (start+len > nocols))
		return -1;

	memcpy(colmap, vis->palette+start, len*sizeof(ggi_color));

	return 0;
}


/* ---------------------------------------------------------------------- */


extern int _ggi_match_palette(ggi_color *pal, int len, ggi_color *col);

ggi_pixel GGI_color_PAL_mapcolor(ggi_visual *vis, ggi_color *col)
{
	ggi_pixel ret;

	if (col == NULL)
		return -1;

	DPRINT_COLOR("PAL_mapcolor(%p, {r=0x%x, g=0x%x, b=0x%x}) called\n",
		     vis, col->r, col->g, col->b);

	if (vis->palette == NULL) {
		DPRINT_COLOR("Error: GGImapcolor with vis->palette==NULL !\n");
		return -1;
	}

	ret = (ggi_pixel) _ggi_match_palette(vis->palette,
		1 << GT_DEPTH(LIBGGI_GT(vis)), col);
	DPRINT_COLOR("PAL_mapcolor returning 0x%x\n", ret);
	return ret;
}

ggi_pixel GGI_color_TRUE_mapcolor(ggi_visual *vis, ggi_color *col)
{
	ggi_pixel ret;
	color_hook *ck = (color_hook *) vis->colorpriv;

	if (col == NULL)
		return -1;

	DPRINT_COLOR("TRUE_mapcolor(%p, {r=0x%x, g=0x%x, b=0x%x}) called\n",
		     vis, col->r, col->g, col->b);

	ret = (DOSHIFT(col->r, ck->red_total - 16) & 
			LIBGGI_PIXFMT(vis)->red_mask)   |
	       (DOSHIFT(col->g, ck->green_total - 16) & 
			LIBGGI_PIXFMT(vis)->green_mask) |
	       (DOSHIFT(col->b, ck->blue_total - 16) & 
			LIBGGI_PIXFMT(vis)->blue_mask);

	DPRINT_COLOR("TRUE_mapcolor returning 0x%x\n", ret);
	return ret;
}

ggi_pixel GGI_color_GREY_mapcolor(ggi_visual *vis, ggi_color *col)
{
	ggi_pixel ret;

	if (col == NULL)
		return -1;

	DPRINT_COLOR("GREY_mapcolor(%p, {r=0x%x, g=0x%x, b=0x%x}) called\n",
		     vis, col->r, col->g, col->b);

	/* NB: This formula is not very good... */
	
	ret = (col->r*82 + col->g*124 + col->b*50)
		>> (24 - GT_DEPTH(LIBGGI_GT(vis)));
	DPRINT_COLOR("GREY_mapcolor returning 0x%x\n", ret);
	return ret;
}


/* ---------------------------------------------------------------------- */


int GGI_color_PAL_unmappixel(ggi_visual *vis, ggi_pixel pixel, ggi_color *col)
{
	if (col == NULL)
		return -1;
	
	if (vis->palette == NULL) {
		DPRINT_COLOR("Error: GGIunmappixel with vis->palette==NULL !\n");
		return -1;
	}

	if (pixel >= (1 << GT_DEPTH(LIBGGI_GT(vis))))
		return -1;

	*col = vis->palette[pixel];
	return 0;
}

int GGI_color_TRUE_unmappixel(ggi_visual *vis, ggi_pixel pixel, ggi_color *col)
{
	color_hook *ck = (color_hook *) vis->colorpriv;

	if (col == NULL)
		return -1;

	col->r = DOSHIFT(pixel & LIBGGI_PIXFMT(vis)->red_mask,
			 16 - ck->red_total);
	col->g = DOSHIFT(pixel & LIBGGI_PIXFMT(vis)->green_mask,
			 16 - ck->green_total);
	col->b = DOSHIFT(pixel & LIBGGI_PIXFMT(vis)->blue_mask,
			 16 - ck->blue_total);

	return 0;
}

int GGI_color_GREY_unmappixel(ggi_visual *vis, ggi_pixel pixel, ggi_color *col)
{
	int intensity;
	
	if (col == NULL)
		return -1;
	
	intensity = (pixel << (24 - GT_DEPTH(LIBGGI_GT(vis)))) >> 8;

	col->r = col->g = col->b = intensity;

	return 0;
}
