static inline void port_out( int value, int port )
{
	__asm__ volatile ("outb %0,%1"
	: : "a" ((unsigned char)value), "d" ((unsigned short)port));
}

static inline void port_outw( int value, int port ) {
	__asm__ volatile("outw %0,%1"
	: : "a" ((unsigned short)value), "d" ((unsigned short)port));
}

static inline int port_in( int port )
{
	unsigned char value;
	__asm__ volatile ("inb %1,%0"
		: "=a" (value)
		: "d" ((unsigned short)port));
	return value;
}

static inline int port_inw( int port )
{
	unsigned short value;
	__asm__ volatile ("inw %1,%0"
		: "=a" (value)
		: "d" ((unsigned short)port));
	return value;
}

#define inb port_in
#define inw port_inw
#define outb(port, value) port_out(value, port)
#define outw(port, value) port_outw(value, port)

int io_enable(void)
{
  ioperm(0x70, 1, 1);
  ioperm(0x71, 1, 1);
  return 0;
}

int io_disable(void)
{
  ioperm(0x70, 0, 1);
  ioperm(0x71, 0, 1);
  return 0;
}

int get_cmos(int index)
{
  int r;

  io_enable();
  outb(0x70, index);
  r = inb(0x71);
  io_disable();
  return r;
}

int set_cmos(int index, int value)
{
  io_enable();
  outb(0x70, index);
  outb(0x71, value);
  return 0;
}

int get_physmem(int offset)
{
    int r = -1;
    int mem_fd, i;
    u_char *memptr = valloc(0x10000);
    u_char *p;

    mem_fd = open("/dev/mem", O_RDWR);
    if (mem_fd == -1){
      return -1;
    }
    mmap(memptr,
         0x10000,
         PROT_READ | PROT_WRITE | PROT_EXEC,
         MAP_SHARED | MAP_FIXED,
         mem_fd,
         0x00000);
    p = memptr + offset;
    r = *p;
    close(mem_fd);
    munmap(memptr, 0x10000);
    free(memptr);
    return r;
}

int set_physmem(int offset, int value)
{
    int mem_fd, i;
    u_char *memptr = valloc(0x10000);
    u_char *p;

    mem_fd = open("/dev/mem", O_RDWR);
    if (mem_fd == -1){
      return -1;
    }
    mmap(memptr,
         0x10000,
         PROT_READ | PROT_WRITE | PROT_EXEC,
         MAP_SHARED | MAP_FIXED,
         mem_fd,
         0x00000);
    p = memptr + offset;
    *p = value;
    close(mem_fd);
    munmap(memptr, 0x10000);
    free(memptr);
    return 0;
}

int a2i(char s)
{
    int  r;

    r = -1;
    if (s >= '0' && s <= '9')  r = s - '0';
    return r;
}

char i2a(int i)
{
    char r;

    r = ' ';
    if (i >= 0 && i <= 9)  r = i + '0';
    return r;
}


int islibretto(void)
{
    int r=1;
    int mem_fd, i;
    u_char *memptr = valloc(0x10000);
    u_char *p;
    char s[5];

    mem_fd = open("/dev/mem", O_RDWR);
    if (mem_fd == -1){
      printf("Can't open /dev/mem.\n");
      exit(0);
    }
    mmap(memptr,
         1024,
         PROT_READ | PROT_WRITE | PROT_EXEC,
         MAP_SHARED | MAP_FIXED,
         mem_fd,
         0xf0000);
    p = memptr + 0x004c;
    for (i=0; i<4; i++)  s[i] = *p++;
    s[4] = '\0';
    if (strcmp(s, "20CT") == 0)  r = 0;
    else if (strcmp(s, "50CT") == 0)  r = 0;
    close(mem_fd);
    munmap(memptr, 0x10000);
    free(memptr);
    return r;
}

