#include <stdio.h>
#include <sys/types.h>
#include "bios.h"

extern u_short smi(short, short, u_short);
extern u_short smi2(short, short, u_short *);

u_short bios_write(short mode, u_short data)
{
  u_short ret;

  ret = smi(BIOS_OPEN, 0x0000, 0x0000);
  if ((ret  & 0xff00) != 0x0000){
    fprintf(stderr, "bios_write: Can not open BIOS: ret=0x%x, mode=0x%x\n", ret, mode);
    exit(1);
  }
  ret = smi(BIOS_SET, mode, data) & 0xff00;
  smi(BIOS_CLOSE, 0x0000, 0x0000);
  return (ret);
}

u_short bios_read(short mode, u_short *p)
{
  u_short ret;

  ret = smi(BIOS_OPEN, 0x0000, 0x0000);
  if ((ret  & 0xff00) != 0x0000){
    fprintf(stderr, "bios_read: Can not open BIOS: ret=0x%x, mode=0x%x\n", ret, mode);
    exit(1);
  }
  ret = smi2(BIOS_GET, mode, p) & 0xff00;
  smi(BIOS_CLOSE, 0x0000, 0x0000);
  return (ret);
}
