/***************************************************************************
                          nation.c  -  description
                             -------------------
    begin                : Wed Jan 24 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <SDL.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "sdl.h"
#include "tools.h"
#include "dynlist.h"
#include "file.h"
#include "nation.h"

extern Sdl sdl;

/* open nation file */
FILE* open_nation_file( char *file_name )
{
    char full_path[256];
    sprintf(full_path, "%s/nations/%s", SRC_DIR, file_name);
    printf( "parsing nations/%s\n", file_name );
    return file_open( full_path );
}

/* read nations from file */
Nation** read_nations( char *file_name, int *nation_count )
{
    int i = 0;
    char *cur_arg = 0; /* current argument entry */
    char **args = 0;
    int arg_count = 0;
    Nation **nations = 0;
    char path[512];
    int flag_width = 0, flag_height = 0;
    SDL_Surface *flag_pic = 0;
    FILE *file = 0;

    /* open file */
    if ( ( file = open_nation_file( file_name ) ) == 0 ) return 0;

    /* read flag size */
    if ( ( cur_arg = get_arg( file, "flag_width", RESET_FILE_POS ) ) == 0 ) goto failure;
    flag_width = atoi( cur_arg );
    FREE( cur_arg );
    if ( ( cur_arg = get_arg( file, "flag_height", RESET_FILE_POS ) ) == 0 ) goto failure;
    flag_height = atoi( cur_arg );
    FREE( cur_arg );
    /* get flag picture */
    if ( ( cur_arg = get_arg( file, "flag_pic", RESET_FILE_POS ) ) == 0 ) goto failure;
    sprintf( path, "flags/%s", cur_arg );
    flag_pic = load_surf( path,  SDL_SWSURFACE );
    FREE( cur_arg );

    /* count nations */
    (*nation_count) = count_arg( file, "nation" );

    /* create nations structure and memset to 0 */
    nations = calloc( (*nation_count), sizeof( Nation* ) );
    for ( i = 0; i < *nation_count; i++ ) {
        nations[i] = malloc( sizeof( Nation ) );
        memset( nations[i], 0, sizeof( Nation ) );
    }

    /* read nations */
    find_token( file, "nation", RESET_FILE_POS, WARNING );
    for ( i = 0; i < (*nation_count); i++) {
        /* get info */
        args = get_arg_cluster( file, "nation", &arg_count, FROM_CURRENT_FILE_POS, WARNING );
        nations[i]->entry_name = strdup( args[0] );
        nations[i]->name = strdup( args[1] );
        /* create small flag */
        nations[i]->flag_pic = create_surf( flag_width, flag_height, SDL_SWSURFACE );
        FULL_DEST( nations[i]->flag_pic );
        SOURCE( flag_pic, 0, atoi( args[2] ) * flag_height );
        blit_surf();
        delete_arg_cluster( args, arg_count );
    }

    fclose( file );
    SDL_FreeSurface( flag_pic );
    return nations;

failure:
    if ( file ) fclose( file );
    if ( flag_pic ) SDL_FreeSurface( flag_pic );
    if ( nations ) {
        for ( i = 0; i < *nation_count; i++ )
            delete_nation( nations[i] );
        FREE( nations );
    }
    return 0;
}

/* delete nation */
void delete_nation( Nation *nation )
{
    if ( nation == 0 ) return;

    if ( nation->entry_name ) FREE( nation->entry_name );
    if ( nation->name ) FREE( nation->name );
    if ( nation->flag_pic ) SDL_FreeSurface( nation->flag_pic );

    FREE( nation ); nation = 0;
}

