/***************************************************************************
                          window.h  -  description
                             -------------------
    begin                : Sun Jan 28 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __GUI_H
#define __GUI_H

/* refresh styles */
enum {
    IGNORE_CHIL = ( 1L << 1 ),
    IF_NEEDED = ( 1L << 2 ),
    ALL = ( 1L << 3 ),
    NO_SCREEN_REF = ( 1L << 4 ),
    /* window flags ( also IGNORE_CHIL above ) */
    CLEAR_PIC = ( 1L << 2 )
};

/* misc window styles */
enum {
    NO_REFRESH = 0,
    REFRESH = 1,
    SHOW = 1,
    HIDE = 0,
    VERT = 0,
    HORI = 1
};

/* listbox flags */
enum {
    NO_SELECT = ( 1L << 7 ),
    SINGLE_SELECT = ( 1L << 8 ),
    MULTI_SELECT = ( 1L << 9 ),
    TRANS_LIST = ( 1L << 10 ), /* transparent list; surface passed contains the frame */
    TRANS_EDIT = ( 1L << 11 )
};

/* some standard ids */
enum {
    ID_LIST_LABEL = -100, /* do not use listboxes with more than 99 visible labels!!!! */
    ID_NONE = 0,
    ID_ACCEPT,
    ID_CANCEL,
    ID_INC,
    ID_DEC,
    ID_TRACK,
    ID_LIST_SCROLL,
};

/* window types */
enum {
    PARENT_WINDOW = 0,
    BUTTON,
    TEXT_BUTTON,
    LABEL,
    EDIT,
    SCROLL,
    LIST,
    ICON,
    FRAME_ICON
};

typedef struct _Window {
    /* have all windows in common */
    int id;
    int type;
    int flags;
    SDL_Surface *pic; /* will be just a pointer soon */
    SDL_Surface *back_pic; /* save former background */
    SDL_Surface *add_icon; /* additional icon used for FRAME_ICON */
    Font *font; /* do not delete it is just a pointer ! */
    int x, y; /* absolute position in screen */
    int rel_x, rel_y; /* relative position in parent window */
    int width, height;
    Text *text; /* text */
    int align; /* alignment */
    int ref; /* needs to be refreshed ? */
    int active; /* window active ? */
    int sel; /* selected ? */
    int focus; /* has focus? (mouse in window) */
    Dyn_List chil; /* children windows */
    struct _Window *parent; /* parent */
    /* sepcial data for various types */
    int border;
    int pos; /* position somewhere */
    int min;
    int max; /* limit pos to a range */
    int step; /* step for page up/down (in case of listbox the number of labels displayed)*/
    int dir; /* direction */
    int button_size; /* size of a scrollbar button */
    int *line_sel; /* line selections -- only needed for multiselection */
    int sel_lines_count; /* number of selected lines */
    int cur_line_sel; /* current line selected */
    int icon_width, icon_height, icon_x, icon_y;
    int back_color; /* background color for a label */
    int trans; /* show window picture transparent? */
    int frame_size; /* if window is transparent the frame is kept opaque */
    int is_switch; /* some buttons can memorize if they were pressed or released */
    int is_on; /* switched on? */
    int has_scroll; /* true if it's a listbox with scrollbar */
    int char_limit; /* character limit for one label in a list box */
    struct _Window *list_scroll; /* frame icons are connected to an scrollbar and handle WHEEL_UP/DOWN
    for it if this pointer is et */
#ifdef WITH_SOUND
    /* sounds */
    Sound_Chunk *click_sound; /* if != 0 played when button was clicked; is just a pointer and not
    freed by window */
    Sound_Chunk *edit_sound; /* if != 0 played when key was pressed */
#endif
} Window;

/* create parent window */
Window* create_parent_window( SDL_Surface *pic );
/* create wallpapered parent window; add a frame if frame_pic != 0 */
Window *create_wallpaper_window( SDL_Surface *pic, SDL_Surface *frame_pic, int width, int height );
/* create transparent window with frame */
Window *create_trans_window( SDL_Surface *frame_pic, int width, int height );
/* create button window ( and add to parent automatically )*/
Window* create_button( Window *parent, int id, SDL_Surface *pic, int x, int y, int width, int height,
                       char *text, Window *label );
/* create switch button  ( and add to parent automatically )*/
Window* create_switch( Window *parent, int id, SDL_Surface *pic,
                       int x, int y, int width, int height,char *text, Window *label,
                       int is_on );
/* create simple button (no label) window ( and add to parent automatically )*/
Window* create_simple_button( Window *parent, int id, SDL_Surface *pic, int x, int y,
                              int width, int height );
/* create text button window ( and add to parent automatically )*/
Window* create_text_button( Window *parent, int id, SDL_Surface*pic, int x, int y, int width,
                            int height, Font *font, char *text );
/* create label window ( and add to parent automatically )*/
Window* create_label( Window *parent, int id, int x, int y, int width, int height, Font *font,
                      int align, char *text );
/* create edit window ( and add to parent automatically )*/
Window* create_edit( Window *parent, int id, SDL_Surface *pic, int x, int y, int width, int height,
                     int border, Font *font, char *text, int max, int flags );
/* create scrollbar window ( and add to parent automatically )*/
Window* create_scroll( Window *parent, int id, SDL_Surface *pic, int x, int y, int width, int height,
                       int dir, SDL_Surface *inc_pic, SDL_Surface *dec_pic, SDL_Surface *pos_pic,
                       int min, int max, int step, int pos );
/* create listbox window */
Window* create_list( Window *parent, int id, SDL_Surface *pic, int x, int y, int width, int height,
                     int border, Font *font, Text *text, int flags, int back_color,
                     SDL_Surface *scroll_pic,
                     SDL_Surface *inc_pic, SDL_Surface *dec_pic, SDL_Surface *pos_pic,
                     int scroll_size );
/* create simple listbox window (no scrollbar)*/
Window* create_simple_list( Window *parent, int id, SDL_Surface *pic, int x, int y, int width, int height,
                     int border, Font *font, Text *text, int flags, int back_color );
/* create icon window ( and add to parent automatically )*/
Window* create_icon( Window *parent, int id, int x, int y, int width, int height, SDL_Surface *icon,
                     int icon_x, int icon_y, int icon_width, int icon_height );
/* create icon with frame*/
Window* create_frame_icon( Window *parent, int id, SDL_Surface *frame_pic, int x, int y, int width, int height, SDL_Surface *icon,
                     int icon_x, int icon_y, int icon_width, int icon_height );

/* delete window */
void delete_window( void *poi );

/* open (parent) window */
void open_window( Window *window, int type );

/* close (parent) window */
void close_window( Window *window );

/* hide window */
void hide_window( Window *window, int ref );

/* move window to position and get new background */
void move_window( Window *window, int x, int y, int ref );

/* handle window event */
void handle_window_event( Window *window, SDL_Event *event, Window **used_child );

/* update the changed parts of a window and
refresh if NO_SCREEN_REF is not set */
void update_window( Window *window, int flags );

/* check if on window */
inline int on_window( Window *window, int x, int y);

/* set just a single line of text */
void set_simple_window_text( Window *window, char *text, int ref );
/* set text */
void set_window_text( Window *window, Text *text, int ref );

/* set icon */
void set_icon( Window *window, SDL_Surface *pic, int x, int y, int width, int height, int ref);

/* return window pointer from parent and id */
Window* get_child( Window *parent, int id );

/* adjust track button position from scrollbar */
void adjust_track_button( Window *window, int ref );

/* return if switch if set */
int is_on( Window *window );

/* set active flag to active and refresh if wanted */
void set_active( Window *window, int active, int ref );

// set scrollbar range //
void set_scroll_range( Window *window, int min, int max, int step, int pos, int ref );

/*
====================================================================
(Un)Select icon
====================================================================
*/
void select_icon( Window *icon, int ref );
void unselect_icon( Window *icon, int ref );

#endif
