/***************************************************************************
                          campaign.c  -  description
                             -------------------
    begin                : Thu Jun 28 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <SDL.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef WITH_SOUND
#include <SDL_mixer.h>
#include "audio.h"
#endif

#include "sdl.h"
#include "config.h"
#include "tools.h"
#include "dynlist.h"
#include "file.h"
#include "nation.h"
#include "unit.h"
#include "player.h"
#include "date.h"
#include "map.h"
#include "scenario.h"
#include "campaign.h"

extern Scen scen;
Camp camp;

/* load campaign */
int load_camp( char *file_name )
{
    FILE *file = 0;
    char path[512];
    char *cur_arg = 0;
    int i;

    /* open file */
    sprintf( path, "%s/campaigns/%s", SRC_DIR, file_name );
    printf( "parsing: campaigns/%s\n", file_name );
    if ( ( file = file_open( path ) ) == 0 ) return 0;

    clear_camp();

    camp.file_name = strdup( file_name );

    /* campaign name */
    if ( ( camp.title = get_arg( file, "title", RESET_FILE_POS ) ) == 0 )
         camp.title = strdup( "No Title" );
    /* description */
    if ( ( camp.desc = get_arg( file, "desc", RESET_FILE_POS ) ) == 0 )
        camp.desc = strdup( "No Description" );
    /* authors */
    if ( ( camp.authors = get_arg( file, "authors", RESET_FILE_POS ) ) == 0 )
        camp.authors = strdup( "unknown" );

    /* count scenarios */
    camp.scen_count = count_arg( file, "scen" );

    /* get mem */
    camp.scen_info = calloc( camp.scen_count, sizeof( Camp_Scen_Info ) );

    /* get scenario stuff */
    find_token( file, "scen", RESET_FILE_POS, NO_WARNING );
    for ( i = 0; i < camp.scen_count; i++ ) {

        /* scenario file name */
        if ( ( cur_arg = get_arg( file, "scen", FROM_CURRENT_FILE_POS ) ) == 0 ) goto failure;
        camp.scen_info[i].name = strdup( cur_arg );
        FREE( cur_arg );

        /* briefing */
        if ( ( cur_arg = get_arg( file, "briefing", FROM_CURRENT_FILE_POS ) ) == 0 ) goto failure;
        camp.scen_info[i].brief = strdup( cur_arg );
        FREE( cur_arg );

        /* next scenarios */
        if ( ( cur_arg = get_arg( file, "next_scen_major", FROM_CURRENT_FILE_POS ) ) == 0 ) goto failure;
        camp.scen_info[i].next_name_major = strdup( cur_arg );
        FREE( cur_arg );
        if ( ( cur_arg = get_arg( file, "next_scen_minor", FROM_CURRENT_FILE_POS ) ) == 0 ) goto failure;
        camp.scen_info[i].next_name_minor = strdup( cur_arg );
        FREE( cur_arg );

    }

    /* final briefing */
    if ( ( cur_arg = get_arg( file, "final_message", RESET_FILE_POS ) ) == 0 ) goto failure;
    camp.final_msg = strdup( cur_arg );
    FREE( cur_arg );

    close_file( file );

    camp.loaded = 1;

    return 1;

failure:
    clear_camp( );
    return 0;
}

/* delete campaign data*/
void clear_camp( )
{
    int i;

    if ( camp.file_name ) FREE( camp.file_name );
    if ( camp.title ) FREE( camp.title );
    if ( camp.desc ) FREE( camp.desc );
    if ( camp.authors ) FREE( camp.authors );

    if ( camp.scen_info ) {
        for ( i = 0; i < camp.scen_count; i++ ) {
            if ( camp.scen_info[i].name ) free ( camp.scen_info[i].name );
            if ( camp.scen_info[i].next_name_major ) free ( camp.scen_info[i].next_name_major );
            if ( camp.scen_info[i].next_name_minor ) free ( camp.scen_info[i].next_name_minor );
            if ( camp.scen_info[i].brief ) free ( camp.scen_info[i].brief );
        }
        FREE( camp.scen_info );
    }
    if ( camp.final_msg ) FREE( camp.final_msg );
    memset( &camp, 0, sizeof( Camp ) ); /* includes camp::loaded */
}

