/*
Received: from magi.com for rwscott@magi.com
 with iSTAR POP Server istar-vpopper (v1.13 12.2.1996) Sat Dec 13 16:06:11 1997
X-From_: lesstif-request@hungry.com Sat Dec 13 15:53:41 1997
Received: from terror.hungry.com [169.131.1.215
	by mail.magi.com with esmtp (Exim 1.80 #5)
	id 0xgyZA-0001DW-00; Sat, 13 Dec 1997 15:53:41 -0500
Received: (from slist@localhost
	by terror.hungry.com (8.8.7/8.8.7) id MAA22161;
	Sat, 13 Dec 1997 12:50:24 -0800 (PST)
Resent-Date: Sat, 13 Dec 1997 12:50:24 -0800 (PST)
Date: Sat, 13 Dec 1997 14:44:46 -0600 (CST)
From: "Jon A. Christopher" <jon@quorum.tamu.edu>
To: Lesstif Mailing List <lesstif@Hungry.COM>
Subject: improper geometry handling in FileSelectionDialog
Message-ID: <Pine.SGI.3.95.971213143416.21158A-100000@quorum.tamu.edu>
MIME-Version: 1.0
Content-Type: TEXT/PLAIN; charset=US-ASCII
Resent-Message-ID: <"yI1WnC.A.GQF.QQvk0"@terror.hungry.com>
Resent-From: lesstif@Hungry.COM
X-Mailing-List: <lesstif@Hungry.COM> archive/latest/700
X-Loop: lesstif@Hungry.COM
Precedence: list
Resent-Sender: lesstif-request@Hungry.COM
Resent-Bcc:

Hello,

I've noticed that FileSelectionDialogs do not handle geometry correctly
under certain cases.  If there's a menubar in the dialog, but no managed
buttons in the menu bar, any action (filter, double clicking a directory,
etc) causes the dialog to grow larger.  SGI Motif 1.2 doesn't exhibit this
behavior.  

In the attached sample code, first press Cancel in the dialog. This unmanages the
button in the menubar.  Next press filter, or double click on a directory
name, and watch the dialog box grow!

Stepping throught the code for FileSB.c, I've isolated the problem to a
XtSetValues call in defaultDirSearchProc(), but it may simply be showing
up there because the display is only updated at that time.  Sorry, no
patch.

-jon
*/

/* test/filesb/test7.c */
#include <Xm/XmAll.h>
Widget GXCreateFileBox(Widget parent);
Widget menubar,button;

static char *FallBack[] = {
		"*.geometrySlop: 0",
		NULL
};

Widget GXTopWidget, GXClipBox;
int main(int argc, char **argv)
{
  XtAppContext theApp;
  Widget label;
  make_tmp_dir_tree();

  GXTopWidget= XtVaAppInitialize(&theApp, "test1", NULL, 0, &argc, argv,
				 FallBack, NULL); 
  label = XmCreateLabel(GXTopWidget, "Label", NULL, 0);
  XtManageChild(label);
  XtManageChild(GXCreateFileBox(GXTopWidget));
  XtRealizeWidget(GXTopWidget);

  
    
{
    static XtWidgetGeometry Expected[] = {
   CWWidth | CWHeight            ,   57,   73,   34,   17, 0,0,0, /* Label */ 
    };
    PrintDetails(GXTopWidget,Expected);
};
  LessTifTestMainLoop(GXTopWidget);

  XtAppMainLoop(theApp);
  exit(0);
}

static void CancelCB()
{
  if (XtIsManaged(button))
    XtUnmanageChild(button);
  else
    XtManageChild(button);
}

Widget
GXCreateFileBox(Widget parent)
/*-
 * create a FileSelectionBox child of parent  
-*/
{
    Arg args[20];
    int n = 0;
    Widget filew, menu;
    Widget work;

    n = 0;
    /* XtSetArg(args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL);  n++; */
    filew = XmCreateFileSelectionDialog(parent, "FileBox", args, n);
    XtAddCallback(filew,XmNcancelCallback, (XtCallbackProc)CancelCB, NULL);
    set_path(filew);
    /* these calls are here to force the menu bar to the top, but it fails
       under lesstif */
    work = XmCreateRowColumn(filew, "FileBoxWork", NULL, 0);
    XtManageChild(work);
    work = XmCreateSeparator(filew, "Separator", NULL, 0);
    XtManageChild(work);
    XtManageChild(menu=XmCreateMenuBar(filew, "Menu Bar",NULL,0));
    XtManageChild(button=XmCreateCascadeButton(menu,"Button",NULL,0));
    menubar=menu;
    return (filew);
}
