/*
 * Simple application that uses the Xp API.
 * No XmPrint, no DtPrint, no Print Dialog Manager are used.
 *
 * Maybe this should look at $XPSERVERLIST instead of just
 *	using :1 as the printer display.
 */
static const char rcsid[] = "$Header: /cvsroot/lesstif/lesstif/test/Xm-2.1/print/test3.c,v 1.6 2000/12/20 19:55:36 dannybackx Exp $";

#include <stdlib.h>
#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/extensions/Print.h>
#include <Xm/XmAll.h>

Screen	*PrintScreen = NULL;

void PrintPageCB(Widget w, XtPointer client, XtPointer call)
{
	XmPrintShellCallbackStruct *p = (XmPrintShellCallbackStruct *)call;

	fprintf(stderr, "PrintPageCB()\n");
}

Widget CreateWindow(Widget top, Display *dpy, Screen *scr)
{
	Widget	w, arrow;
	Arg	al[10];
	int	ac;

	ac = 0;
	XtSetArg(al[ac], XmNheight, 600); ac++;
	XtSetArg(al[ac], XmNwidth, 400); ac++;

	w = XmPrintSetup(top, scr, "print_shell", al, ac);
	XtAddCallback(w, XmNpageSetupCallback, PrintPageCB, 0);

#if 1
	arrow = XmCreateFileSelectionBox(w, "fsd", NULL, 0);
	XtManageChild(arrow);
#endif
#if 0
	arrow = XmCreateMessageBox(w, "fsd", NULL, 0);
	XtManageChild(arrow);
#endif
#if 1
	if (! arrow)
		arrow = XtVaCreateManagedWidget("push", xmPushButtonWidgetClass, w,
			XmNwidth,	200,
			XmNheight,	400,
		NULL);
#endif
	/* Does something ! */
	if (! arrow)
		arrow = XtVaCreateManagedWidget("Button1", xmArrowButtonWidgetClass, w, 
			XmNarrowDirection,	XmARROW_UP,
			XmNheight,		200,
			XmNwidth,		200,
		NULL);

	return w;
}

int
main(int argc, char *argv[])
{
	XtAppContext	appc;
	Widget		top, arrow, w;
	Display		*pdpy;
	XPPrinterList	plist;
	int		nlist, i;
	XPContext	pctxt;
	char		*attrPool;
	Screen		*pscreen;
	Window		win;

	top = XtVaAppInitialize(&appc, "drawingArea", NULL, 0,
                               &argc, argv, NULL, NULL);

	arrow = XtVaCreateManagedWidget("Button1", xmArrowButtonWidgetClass, top, 
			XmNarrowDirection,	XmARROW_UP,
		NULL);

	XtRealizeWidget(top);

	pdpy = XtOpenDisplay(appc,
		/* Display String */	":1",
		"print",
		"Print",
		NULL,
		0,
		&argc, argv);
	if (!pdpy) {
		fprintf(stderr, "Cannot connect to :1\n");
		exit(1);
	}
	PrintScreen = DefaultScreenOfDisplay(pdpy);

	plist = XpGetPrinterList(pdpy, "", &nlist);

	if (nlist)
		for (i=0; i<nlist; i++)
			fprintf(stderr, "Printer[%d] is '%s' (%s)\n",
				i, plist[i].name,
				plist[i].desc);
	else
		fprintf(stderr, "XpGetPrinterList() : No printers\n");

	pctxt = XpCreateContext(pdpy, plist[0].name);
	XpFreePrinterList(plist);

/*	attrPool = XpGetAttributes(pdpy, pctxt, poolType);
	XpSetAttributes(pdpy, pctxt, poolType, attrPool, XPAttrMerge); */

	XpSetContext(pdpy, pctxt);

	XpStartJob(pdpy, XPSpool);

	pscreen = XpGetScreenOfContext(pdpy, pctxt);
	w = CreateWindow(top, pdpy, pscreen);

	XtRealizeWidget(w);
	win = XtWindow(w);

	XpStartPage(pdpy, win);

	XmRedisplayWidget(w);
	XmRedisplayWidget(w);
	XmRedisplayWidget(w);

	XpEndPage(pdpy);
	XpEndJob(pdpy);
	XpDestroyContext(pdpy, pctxt);

	XtAppMainLoop(appc);
	exit(0);
}
