/*
 * Simple application that uses the XmPrint API.
 * This application uses the DtPrint and the XmPrint functions,
 * but without a print dialog manager.
 *
 * Do *not* try this yet, it doesn't work.
 */
static const char rcsid[] = "$Header: /cvsroot/lesstif/lesstif/test/Xm-2.1/print/test2.c,v 1.7 2000/12/20 19:55:36 dannybackx Exp $";

#include <stdlib.h>
#include <stdio.h>

#include <Xm/XmAll.h>
#include <Dt/Print.h>


/*
 * Example of Page Setup Callback
 */
void PageSetupCB(Widget w, XtPointer client, XtPointer call)
{
	Widget				print_shell = w;
	XmPrintShellCallbackStruct	*pr_cbs = call;
	int				*num = client;
	static Widget			form, text;
	char				buf[10];

	fprintf(stderr, "PageSetupCB()\n");

	/* don't do anything after last page is printed */
	if (pr_cbs->last_page)
		return;

	/* create the widgets once */
	if (!form) {
		form = XmCreateForm(print_shell, "form", NULL, 0);
		text = XmCreateTextField(form, "text", NULL, 0);
	}

	/* setup app's data in print text widget */
	sprintf(buf, "%d", *num);
	XmTextSetString(text, buf);

	num++;
	if (*num > 9)
		pr_cbs->last_page = True;
}

/*
 * XPFinishProc
 */
void FinishPrintToFile(Display *dpy, XPContext context, XPGetDocStatus status, XPointer client)
{
}

void PdmNotifyCB(Widget w, XtPointer client, XtPointer call)
{
}

/*
 * Set up a print server connection
 */
void OKCallback(Widget w, XtPointer client, XtPointer call)
{
	DtPrintSetupCallbackStruct *pbs = call;
	static Widget shell;
	static int num;          /* app data to print */
	int	save_data = XPGetData;

	fprintf(stderr, "OKCallback()\n");

	if (!shell) {
		shell = XmPrintSetup(w, pbs->print_data->print_screen, "Print", NULL, 0);

		if (! shell) {
			exit(1);
		}
		XtAddCallback(shell, XmNpageSetupCallback, PageSetupCB, &num);
		XtAddCallback(shell, XmNpdmNotificationCallback, PdmNotifyCB, &num);
	}

	num = 0;

	/* check print-to-file & print */
	if (pbs->print_data->destination == DtPRINT_TO_FILE)
		save_data = XPGetData;
 
	/* start job must precede XpGetDocumentData in XmPrintToFile */
	XpStartJob(XtDisplay(shell), save_data);
 
	/* setup print to file */
	if (pbs->print_data->destination == DtPRINT_TO_FILE)
	{
		if (!XmPrintToFile(XtDisplay(shell),
				NULL /* pbs->dest_info */,
				FinishPrintToFile, NULL)) {
			/* output some kind of error message */
			XpCancelJob(XtDisplay(shell), True);
 
			/* go back to the event loop as if we had never printed */
			return;
		}
	}
}

static void popup(Widget w, XtPointer client, XtPointer call)
{
	Widget	pd = (Widget)client;

	if (pd)
		XtManageChild(pd);
}

int
main(int argc, char *argv[])
{
	XtAppContext	appc;
	Widget		toplevel, arrow, pd;
	Display		*pdpy;

	toplevel = XtVaAppInitialize(&appc, "drawingArea", NULL, 0,
                               &argc, argv, NULL, NULL);

	arrow = XtVaCreateManagedWidget("Button1", xmArrowButtonWidgetClass, toplevel, 
			XmNarrowDirection,	XmARROW_UP,
		NULL);

	pd = DtCreatePrintSetupDialog(toplevel, "dialog", NULL, 0);
	XtManageChild(pd);
	XtAddCallback(pd, DtNprintCallback, OKCallback, NULL);

	XtAddCallback(arrow, XmNactivateCallback, popup, pd);

	XtRealizeWidget(toplevel);
	XtAppMainLoop(appc);
	exit(0);
}
