/**
 *
 * $Header: /cvsroot/lesstif/lesstif/lib/Xm-2.1/Print.c,v 1.15 2000/12/03 00:52:40 dannybackx Exp $
 * 
 * Copyright (C) 2000 LessTif Development Team
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/


static const char rcsid[] = "$Header: /cvsroot/lesstif/lesstif/lib/Xm-2.1/Print.c,v 1.15 2000/12/03 00:52:40 dannybackx Exp $";

#include <LTconfig.h>


#ifdef HAVE_LIB_XP

#include <stdio.h>

#include <X11/extensions/Print.h>

#include <Xm/XmP.h>
#include <Xm/Print.h>
#include <Xm/PrintSP.h>

#include <XmI/XmI.h>


/*
 * XmPrintPopupPDM sends a notification to start a print dialog manager
 * on behalf of the application.
 * XmPrintPopupPDM hides the details of the X selection mechanism used for this.
 * The environment variable XPDMDISPLAY, which can have values "print" or "video"
 * which of the widgets passed is used.
 * Possible return values : XmPDM_NOTIFY_FAIL, XmPDM_NOTIFY_SUCCESS.
 */
extern XtEnum
XmPrintPopupPDM(Widget print_shell,
                Widget video_transient_for)
{
   _XmWarning(NULL, "XmPrintPopupPDM(): not yet implemented!");
   return XmPDM_NOTIFY_FAIL;
}


/*
 * XmPrintSetup()
 *
 * Do the appropriate setting
 * Create a realised XmPrintShell (the return value)
 *
 * Goals :
 *	- hide details of Xt
 *	- encourage consistency in setting up print widget hierarchy
 *
 * Parameters :
 *	- video_widget is used to get at the application context etc
 *	- print_screen is a Screen belonging to a Display that's already
 *	  known to Xt.
 *	- print_shell_name is the name of a XmPrintShell to be created
 *	  by this function
 */
extern Widget
XmPrintSetup(Widget video_widget,
             Screen *print_screen,
             String print_shell_name,
             ArgList args,
             Cardinal num_args)
{
	XtAppContext	appc = XtWidgetToApplicationContext(video_widget);
	Widget		as, s;
	char		*appname, *classname;
	Arg		a;

	if (! print_screen) {
		_XmWarning(NULL, "XmPrintSetup: NULL print_screen");
		return NULL;
	}
	if (! video_widget) {
		_XmWarning(NULL, "XmPrintSetup: NULL video_widget");
		return NULL;
	}

	/* FIX ME */
	_XmWarning(NULL, "XmPrintSetup(): not yet implemented!");

	XtGetApplicationNameAndClass(XtDisplay(video_widget),
		&appname, &classname);

	XtSetArg(a, XmNscreen, print_screen);

	as = XtAppCreateShell(appname, classname,
		applicationShellWidgetClass,
		DisplayOfScreen(print_screen),
		&a, 1);

	s = XtCreatePopupShell(print_shell_name,
		xmPrintShellWidgetClass,
		as,
		args, num_args);

	if (!s) {
		_XmWarning(NULL, "XmPrintSetup: NULL XmPrintShell");
		return NULL;
	}

	XtSetMappedWhenManaged(s, False);
	XtRealizeWidget(s);

	return s;
}


extern Boolean
XmIsPrintShell(Widget w)
{
 	return False;
}


/*
 * XmPrintToFile retrieves the data being sent by a Print Server and prints it
 * to a file on the client side.
 */
extern XtEnum
XmPrintToFile(Display		*dpy,
              String		filename,
              XPFinishProc	finish_proc,
              XtPointer		client_data)
{
   _XmWarning(NULL, "XmPrintToFile(): not yet implemented!");
   return False;
}

void
XmRedisplayWidget(Widget w)
{
	int		i;
	XExposeEvent	e;
	Region		r;

	/* See if sending a complete event helps ! */
	e.type = Expose;
	e.display = XtDisplay(w);
	e.window = XtWindowOfObject(w);

	e.width = XtWidth(w);
	e.height = XtHeight(w);
	e.x = XtX(w);
	e.y = XtY(w);

	fprintf(stderr, "XmRedisplayWidget: size is %dx%d\n", e.width, e.height);

	e.count = 0;
	e.send_event = False;
	e.serial = LastKnownRequestProcessed(e.display);

	r = XCreateRegion();
	XtAddExposureToRegion((XEvent *)&e, r);

	/* FIX ME */
	_XmWarning(NULL, "XmRedisplayWidget(): not yet implemented!");

	if (w->core.widget_class->core_class.expose) {
		fprintf(stderr, "XmRedisplayWidget: shell (%d children)\n", MGR_NumChildren(w));
		(w->core.widget_class->core_class.expose) (w, (XEvent *)&e, r);
	} else {
		fprintf(stderr, "XmRedisplayWidget(%d children)\n", MGR_NumChildren(w));
	}

	for (i=0; i<MGR_NumChildren(w); i++) {
		Widget child = MGR_Children(w)[i];
		fprintf(stderr, "XmRedisplayWidget: child %d\n", i);
		if (child->core.widget_class->core_class.expose)
			child->core.widget_class->core_class.expose(child, (XEvent *)&e, r);
	}

	XDestroyRegion(r);
}


#if 0
/* This is already in ImageCache.c */
/*
 * XmGetScaledPixMap retrieves a Pixmap from an XBM or XPM file and potentially
 * scales it to match the printer resolution.
 */
XtEnum
XmGetScaledPixmap(Widget w,
                  char *name,
                  Pixel fg,
                  Pixel bg,
                  int depth,
                  double scaling_ratio)
{
}
#endif /* if 0 */


extern void
__LtPrintDummy(void)
{
/* This function does nothing useful and is never called ...
   It is here to check whether we link all required libraries ! */

   Display *display;
   short   major_version, minor_version;
   Status rc;

   display=_XmGetDefaultDisplay();

   rc=XpQueryVersion(display, &major_version, &minor_version);

   fprintf(stdout, "XpQueryVersion() returns %i.%i\n",
                    major_version, minor_version);
   
}

#endif /* HAVE_LIB_XP */
