/**
 *
 * $Header: /cvsroot/lesstif/lesstif/lib/Dt/DtPrintSetupBox.c,v 1.11 2000/12/20 19:55:35 dannybackx Exp $
 *
 * Copyright  2000 LessTif Development Team
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static const char rcsid[] = "$Header: /cvsroot/lesstif/lesstif/lib/Dt/DtPrintSetupBox.c,v 1.11 2000/12/20 19:55:35 dannybackx Exp $";

#include <LTconfig.h>

#include <stdlib.h>
#include <stdio.h>	/* for debugging only ? */
#include <ctype.h>

#include <Xm/Xm.h>
#include <Xm/XmP.h>
#include <Xm/CommandP.h>
#include <Xm/List.h>
#include <Xm/PushBP.h>
#include <Xm/PushBGP.h>
#include <Xm/RowColumnP.h>
#include <Xm/TransltnsP.h>
#include <Xm/SeparatoGP.h>
#include <Xm/DialogS.h>
#include <Xm/TextF.h>
#include <Xm/MessageB.h>
#include <Xm/SpinB.h>
#include <Xm/ComboBox.h>
#include <Xm/SelectioB.h>

#include <XmI/XmI.h>
#include <XmI/MacrosI.h>
#include <XmI/DebugUtil.h>

#include <Dt/Print.h>
#include <Dt/DtPrintSetupBoxP.h>

/* Forward Declarations */
static void _DtDefaultPrinterInfoProc(Widget w, DtPrintSetupData *print_data);
static void _DtDefaultSelectFileProc(Widget w, DtPrintSetupData *print_data);
static void _DtDefaultSelectPrinterProc(Widget w, DtPrintSetupData *print_data);
static void _DtDefaultSetupProc(Widget w, DtPrintSetupData *print_data);
static void _DtDefaultVerifyPrinterProc(Widget w, DtPrintSetupData *print_data);

static void class_initialize(void);
static void class_part_initialize(WidgetClass w_class);
static void initialize(Widget request, Widget new_w, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static Boolean set_values(Widget current, Widget request, Widget new_w,
			  ArgList args, Cardinal *num_args);
static void insert_child(Widget w);
static void DeleteChild(Widget w);

static void _XmDialogTypeDefault(Widget w, int offset, XrmValue *value);
XmGeoMatrix _DtPrintSetupBoxGeoMatrixCreate(Widget _w, Widget _from, XtWidgetGeometry *_pref);
Boolean _DtPrintSetupBoxNoGeoRequest(XmGeoMatrix _geoSpec);
void _DtPrintSetupBoxGetListItems(Widget wid, int resource_offset, XtArgVal *value);
void _DtPrintSetupBoxGetListItemCount(Widget wid, int resource_offset, XtArgVal *value);
void _DtPrintSetupBoxGetTextColumns(Widget wid, int resource_offset, XtArgVal *value);
void _DtPrintSetupBoxGetTextString(Widget wid, int resource_offset, XtArgVal *value);

static void _DtPrintSetupBoxCreateBottomWorkAreaSeparator(DtPrintSetupBoxWidget sb);
static void _DtPrintSetupBoxCreateTopWorkAreaSeparator(DtPrintSetupBoxWidget sb);
static void _DtPrintSetupBoxCreateButtonSeparator(DtPrintSetupBoxWidget sb);
static void _DtPrintSetupBoxCreateCopiesSpinBox(DtPrintSetupBoxWidget sb);
static void _DtPrintSetupBoxCreateCopiesLabel(DtPrintSetupBoxWidget sb);
static void _DtPrintSetupBoxCreateDescriptionLabel(DtPrintSetupBoxWidget sb);
static void _DtPrintSetupBoxCreateFileName(DtPrintSetupBoxWidget sb);
static void _DtPrintSetupBoxCreateFileNameCheckBox(DtPrintSetupBoxWidget sb);
static void _DtPrintSetupBoxCreateInfoButton(DtPrintSetupBoxWidget sb);
static void _DtPrintSetupBoxCreateName(DtPrintSetupBoxWidget sb);
static void _DtPrintSetupBoxCreateNameLabel(DtPrintSetupBoxWidget sb);
static void _DtPrintSetupBoxCreateSelectFileButton(DtPrintSetupBoxWidget sb);
static void _DtPrintSetupBoxCreateSelectPrinterButton(DtPrintSetupBoxWidget sb);
static void _DtPrintSetupBoxCreateSetupButton(DtPrintSetupBoxWidget sb);

static void _DtPsbUpdatePrinterList(Widget w);

static XtAccelerators text_accelerators_parsed = NULL;

/*
 * Resources for the DtPrintSetupBox class
 */
#define Offset(field) XtOffsetOf(DtPrintSetupBoxRec, printsetup_box.field)
static XtResource resources[] =
{
#if 0
    {
	DtNcancelCallback, DtCCancelCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(cancel_callback),
	XmRImmediate, (XtPointer)NULL
    },
#endif
    {
	DtNclosePrintDisplayCallback, DtCClosePrintDisplayCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(close_print_display_callback),
	XmRImmediate, (XtPointer)NULL
    },
    {
	DtNcopies, DtCCopies, XmRInt,
	sizeof(int), Offset(copies),
	XmRImmediate, (XtPointer)0
    },
    {
	DtNdescription, DtCDescription, XmRXmString,
	sizeof(XmString), Offset(description),
	XmRImmediate, (XtPointer)XmUNSPECIFIED
    },
    {
	DtNfileName, DtCPrintToFileName, XmRString,
	sizeof(String), Offset(file_name),
	XmRImmediate, (XtPointer)NULL
    },
    {
	DtNgetAttributesCallback, DtCGetAttributesCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(get_attributes_callback),
	XmRImmediate, (XtPointer)NULL
    },
    {
	DtNminimizeButtons, DtCMinimizeButtons, XmRBoolean,
	sizeof(Boolean), Offset(minimize_buttons),
	XmRImmediate, (XtPointer)False
    },
    {
	DtNprintCallback, DtCPrintCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(print_callback),
	XmRImmediate, (XtPointer)NULL
    },
    {
	DtNprintDestination, DtCPrintDestination, XmREnum,
	sizeof(XtEnum), Offset(print_destination),
	XmRImmediate, (XtPointer)DtPRINT_TO_PRINTER
    },
    {
	DtNprinterInfoProc, DtCPrinterInfoProc, DmRPrintSetupProc,
	sizeof(DtPrintSetupProc), Offset(printer_info_proc),
	XmRImmediate, (XtPointer)_DtDefaultPrinterInfoProc
    },
    {
	DtNprinterName, DtCPrinterName, XmRString,
	sizeof(String), Offset(printer_name),
	XmRImmediate, (XtPointer)NULL
    },
    {
	DtNprintSetupMode, DtCPrintSetupMode, XmREnum,
	sizeof(XtEnum), Offset(print_setup_mode),
	XmRImmediate, (XtPointer)DtPRINT_SETUP_XP
    },
    {
	DtNselectFileProc, DtCSelectFileProc, DmRPrintSetupProc,
	sizeof(DtPrintSetupProc), Offset(select_file_proc),
	XmRImmediate, (XtPointer)_DtDefaultSelectFileProc
    },
    {
	DtNselectPrinterProc, DtCSelectPrinterProc, DmRPrintSetupProc,
	sizeof(DtPrintSetupProc), Offset(select_printer_proc),
	XmRImmediate, (XtPointer)_DtDefaultSelectPrinterProc
    },
    {
	DtNsetAttributesCallback, DtCSetAttributesCallback, XmRCallback,
	sizeof(XtCallbackList), Offset(set_attributes_callback),
	XmRImmediate, (XtPointer)NULL
    },
    {
	DtNsetupProc, DtCSetupProc, DmRPrintSetupProc,
	sizeof(DtPrintSetupProc), Offset(setup_proc),
	XmRImmediate, (XtPointer)_DtDefaultSetupProc
    },
    {
	DtNverifyPrinterProc, DtCVerifyPrinterProc, DmRPrintSetupProc,
	sizeof(DtPrintSetupProc), Offset(verify_printer_proc),
	XmRImmediate, (XtPointer)_DtDefaultVerifyPrinterProc
    },
    {
	DtNworkAreaLocation, DtCWorkAreaLocation, XmREnum,
	sizeof(XtEnum), Offset(work_area_location),
	XmRImmediate, (XtPointer)DtWORK_AREA_BOTTOM
    },
};

static XmSyntheticResource syn_resources[] =
{
    {
	XmNselectionLabelString,
	sizeof(XmString), Offset(selection_label_string),
	_XmExportXmString, NULL	/* FIX ME */
    },
    {
	XmNlistLabelString,
	sizeof(XmString), Offset(list_label_string),
	_XmExportXmString, NULL	/* FIX ME */
    },
    {
	XmNtextColumns,
	sizeof(short), Offset(text_columns),
	_DtPrintSetupBoxGetTextColumns, NULL
    },
    {
	XmNtextString,
	sizeof(XmString), Offset(text_string),
	_DtPrintSetupBoxGetTextString, NULL	/* FIX ME */
    },
    {
	XmNlistItems,
	sizeof(XmStringTable), Offset(list_items),
	_DtPrintSetupBoxGetListItems, NULL	/* FIX ME */
    },
    {
	XmNlistItemCount,
	sizeof(int), Offset(list_item_count),
	_DtPrintSetupBoxGetListItemCount, NULL	/* FIX ME */
    },
    {
	XmNlistVisibleItemCount,
	sizeof(int), Offset(list_visible_item_count),
	NULL /* FIX ME */ , NULL	/* FIX ME */
    },
    {
	XmNokLabelString,
	sizeof(XmString), Offset(ok_label_string),
	_XmExportXmString, NULL
    },
    {
	XmNapplyLabelString,
	sizeof(XmString), Offset(apply_label_string),
	_XmExportXmString, NULL
    },
    {
	XmNcancelLabelString,
	sizeof(XmString), Offset(cancel_label_string),
	_XmExportXmString, NULL
    },
    {
	XmNhelpLabelString,
	sizeof(XmString), Offset(help_label_string),
	_XmExportXmString, NULL
    }
};


static XtActionsRec actions[] =
{
};


DtPrintSetupBoxClassRec dtPrintSetupBoxClassRec = {
    /* Core class part */
    {
	/* superclass            */ (WidgetClass) &xmBulletinBoardClassRec,
        /* class_name            */ "DtPrintSetupBox",
	/* widget_size           */ sizeof(DtPrintSetupBoxRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ False,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ XtInheritRealize,
	/* actions               */ actions,
	/* num_actions           */ XtNumber(actions),
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ True,
	/* compress_exposure     */ XtExposeCompressMaximal,
	/* compress_enterleave   */ True,
	/* visible_interest      */ False,
	/* destroy               */ destroy,
	/* resize                */ XtInheritResize,
	/* expose                */ XtInheritExpose,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ XtInheritSetValuesAlmost,
	/* get_values_hook       */ NULL,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ XtInheritTranslations,
	/* query_geometry        */ XtInheritQueryGeometry,
	/* display_accelerator   */ NULL,
	/* extension             */ (XtPointer)NULL
    },
    /* Composite class part */
    {
	/* geometry manager */ XtInheritGeometryManager, 
        /* change_managed   */ XtInheritChangeManaged, 
        /* insert_child     */ insert_child,
        /* delete_child     */ DeleteChild,
        /* extension        */ NULL,
    },
    /* Constraint class part */
    {
	/* subresources      */ NULL,
        /* subresource_count */ 0,
        /* constraint_size   */ 0,
        /* initialize        */ NULL,
        /* destroy           */ NULL,
        /* set_values        */ NULL,
        /* extension         */ NULL,
    },
    /* XmManager class part */
    {
        /* translations                 */ XmInheritTranslations,
        /* syn_resources                */ syn_resources,
        /* num_syn_resources            */ XtNumber(syn_resources),
        /* syn_constraint_resources     */ NULL,
        /* num_syn_constraint_resources */ 0,
        /* parent_process               */ XmInheritParentProcess,
        /* extension                    */ (XtPointer)NULL
    },
    /* XmBulletinBoard class part */
    {
	/* always_install_accelerators  */ True,
	/* geo_matrix_create            */ _DtPrintSetupBoxGeoMatrixCreate,
	/* focus_moved_proc             */ XmInheritFocusMovedProc,
	/* extension                    */ NULL,

    },
    /* DtPrintSetupBox part */
    {
	/* list_callback                */ NULL,
	/* extension                    */ NULL,
    }
};


WidgetClass dtPrintSetupBoxWidgetClass = (WidgetClass)&dtPrintSetupBoxClassRec;


static void
class_initialize(void)
{
#if 0
    if (text_accelerators_parsed == NULL)
    {
	text_accelerators_parsed = 
	    XtParseAcceleratorTable(_XmSelectioB_defaultTextAccelerators);
    }
    _XmSelectionBCoreClassExtRec.record_type = XmQmotif;
#endif
}


static void
class_part_initialize(WidgetClass widget_class)
{
    DtPrintSetupBoxWidgetClass sbwc = (DtPrintSetupBoxWidgetClass)widget_class;
    DtPrintSetupBoxWidgetClass swc = (DtPrintSetupBoxWidgetClass)widget_class->core_class.superclass;

    if (sbwc->printsetup_box_class.list_callback == XmInheritCallbackProc)
    {
    	sbwc->printsetup_box_class.list_callback = swc->printsetup_box_class.list_callback;
    }
#if 0
    _XmFastSubclassInit(widget_class, XmSELECTION_BOX_BIT);
#endif
}


/*
 */
static void
initialize(Widget request, Widget new_w, ArgList args, Cardinal *num_args)
{
	DtPrintSetupBoxWidget sb = (DtPrintSetupBoxWidget)new_w;

	SB_List(sb) = NULL;
	SB_ListLabel(sb) = NULL;

	if (SB_DialogType(sb) != XmDIALOG_PROMPT) {
		_DtPrintSetupBoxCreateListLabel(sb);
		_DtPrintSetupBoxCreateList(sb);
	}

	_DtPrintSetupBoxCreateSelectionLabel(sb);
	_DtPrintSetupBoxCreateText(sb);

	_XmSetInitialOfTabGroup((Widget)sb, (Widget)SB_Text(sb));

	SB_Separator(sb) = NULL;

	/* core dump avoidance in GeoUtils */
	SB_Separator(sb) = NULL;
	BB_CancelButton(sb) = NULL;
	SB_OkButton(sb) = NULL;
	PSB_InfoButton(sb) = NULL;
	SB_HelpButton(sb) = NULL;
	SB_CancelLabelString(sb) = NULL;
	SB_OkLabelString(sb) = NULL;
	SB_HelpLabelString(sb) = NULL;
	PSB_PrinterSelectionDialog(new_w) = NULL;

	PSB_PrinterName(new_w) = NULL;			/* Why ? */

	_DtPrintSetupBoxCreateBottomWorkAreaSeparator(sb);
	_DtPrintSetupBoxCreateTopWorkAreaSeparator(sb);
	_DtPrintSetupBoxCreateButtonSeparator(sb);
	_DtPrintSetupBoxCreateOkButton(sb);
	_DtPrintSetupBoxCreateCancelButton(sb);
	_DtPrintSetupBoxCreateHelpButton(sb);
	_DtPrintSetupBoxCreateCopiesSpinBox(sb);
	_DtPrintSetupBoxCreateCopiesLabel(sb);
	_DtPrintSetupBoxCreateDescriptionLabel(sb);
	_DtPrintSetupBoxCreateFileNameCheckBox(sb);
	_DtPrintSetupBoxCreateFileName(sb);
	_DtPrintSetupBoxCreateInfoButton(sb);
	_DtPrintSetupBoxCreateName(sb);
	_DtPrintSetupBoxCreateNameLabel(sb);
	_DtPrintSetupBoxCreateSelectFileButton(sb);
	_DtPrintSetupBoxCreateSelectPrinterButton(sb);
	_DtPrintSetupBoxCreateSetupButton(sb);

#ifdef	DO_FLUSH
	XFlush(XtDisplay(SB_Text(sb)));
#endif

	BB_DefaultButton(new_w) = SB_OkButton(sb);
	_XmBulletinBoardSetDynDefaultButton(new_w, SB_OkButton(sb));

	PSB_PrintSetupData(new_w) = NULL;

	if (PSB_PrintSetupMode(new_w) == DtPRINT_SETUP_XP) {
		/*
		 * The widget must manage an X Printing display connection,
		 * a print context, and provide defaults for a number of X
		 * Printing operations such as printer selection and information
		 * dialogs, and printer verification.
		 */
		PSB_PrintSetupData(new_w) = (DtPrintSetupData *) XtMalloc(sizeof(DtPrintSetupData));
		memset(PSB_PrintSetupData(new_w), 0, sizeof(DtPrintSetupData));
		PSB_PrintSetupData(new_w)->print_display = NULL;
		PSB_PrintSetupData(new_w)->print_screen = NULL;
		DtPrintFillSetupData(NULL, PSB_PrintSetupData(new_w));

//		(*PSB_SelectPrinterProc(new_w))(new_w, PSB_PrintSetupData(new_w));

		_DtPsbUpdatePrinterList(new_w);
	} else {
		PSB_SelectPrinterProc(new_w) = NULL;
	}
}


static void
destroy(Widget w)
{
	XmStringFree(SB_TextString(w));
	if (PSB_PrinterSelectionDialog(w))
		XtDestroyWidget(XtParent(PSB_PrinterSelectionDialog(w)));
}


/*
 * handle element updates
 */
#define	NE(x)	(x(o) != x(sb))
static Boolean
set_values(Widget old,
	   Widget request,
	   Widget new_w,
	   ArgList args,
	   Cardinal *num_args)
{
    DtPrintSetupBoxWidget sb = (DtPrintSetupBoxWidget)new_w;
    DtPrintSetupBoxWidget o = (DtPrintSetupBoxWidget)old;
    Boolean r = False;		/* whether to redisplay */
    Arg al[10];
    int ac;

    /* this is required for every BB subclass */
    BB_InSetValues(new_w) = True;

    /* XmList */
    ac = 0;
    if (NE(SB_ListItems) || NE(SB_ListItemCount))
    {
	XtSetArg(al[ac], XmNitems, SB_ListItems(sb)); ac++;
	XtSetArg(al[ac], XmNitemCount, SB_ListItemCount(sb)); ac++;
	r = True;
    }
    if (ac && SB_List(sb))
    {
	XtSetValues(SB_List(sb), al, ac);
	/* T. Straumann: List made a copy of the item list;
	 *				 we have to adjust SB_ListItems
	 */
	al[0].value = (XtArgVal)&SB_ListItems(sb);
	XtGetValues(SB_List(sb), al, 1);
    }

    /* Text : Text string */
    ac = 0;
    if (NE(SB_TextString))
    {
	String text;

	SB_TextString(sb) = XmStringCopy(SB_TextString(sb));
	XmStringFree(SB_TextString(o));
	if (XmStringGetLtoR(SB_TextString(sb), XmSTRING_DEFAULT_CHARSET, &text))
	{
	    XmTextFieldSetString(SB_Text(sb), text);
	    XtFree(text);
	    r = True;
	}
    }

    /* Labels : Selection Label */
    ac = 0;
    if (NE(SB_SelectionLabelString))
    {
	SB_SelectionLabelString(sb) = XmStringCopy(SB_SelectionLabelString(sb));
	XmStringFree(SB_SelectionLabelString(o));
	XtSetArg(al[ac], XmNlabelString, SB_SelectionLabelString(sb)); ac++;
	r = True;
    }
    if (ac && SB_SelectionLabel(sb))
    {
	XtSetValues(SB_SelectionLabel(sb), al, ac);
    }

    /* Labels : List Label */
    ac = 0;
    if (NE(SB_ListLabelString))
    {
	SB_ListLabelString(sb) = XmStringCopy(SB_ListLabelString(sb));
	XmStringFree(SB_ListLabelString(o));
	XtSetArg(al[ac], XmNlabelString, SB_ListLabelString(sb)); ac++;
	r = True;
    }
    if (ac && SB_ListLabel(sb))
    {
	XtSetValues(SB_ListLabel(sb), al, ac);
    }

    /* Labels : OK Button Label */
    ac = 0;
    if (NE(SB_OkLabelString))
    {
	SB_OkLabelString(sb) = XmStringCopy(SB_OkLabelString(sb));
	XmStringFree(SB_OkLabelString(o));
	XtSetArg(al[ac], XmNlabelString, SB_OkLabelString(sb)); ac++;
	r = True;
    }
    if (ac && SB_OkButton(sb))
    {
	XtSetValues(SB_OkButton(sb), al, ac);
    }

    /* Labels : Cancel Button Label */
    ac = 0;
    if (NE(SB_CancelLabelString))
    {
	SB_CancelLabelString(sb) = XmStringCopy(SB_CancelLabelString(sb));
	XmStringFree(SB_CancelLabelString(o));
	XtSetArg(al[ac], XmNlabelString, SB_CancelLabelString(sb)); ac++;
	r = True;
    }
    if (ac && SB_CancelButton(sb))
    {
	XtSetValues(BB_CancelButton(sb), al, ac);
    }

    /* Labels : Help Button Label */
    ac = 0;
    if (NE(SB_HelpLabelString))
    {
	SB_HelpLabelString(sb) = XmStringCopy(SB_HelpLabelString(sb));
	XmStringFree(SB_HelpLabelString(o));
	XtSetArg(al[ac], XmNlabelString, SB_HelpLabelString(sb)); ac++;
	r = True;
    }
    if (ac && SB_HelpButton(sb))
    {
	XtSetValues(SB_HelpButton(sb), al, ac);
    }

    BB_InSetValues(new_w) = False;

    if (r && (XtClass(new_w) == xmSelectionBoxWidgetClass))
    {
	_XmBulletinBoardSizeUpdate(new_w);

	return False;
    }

    return r;
}


/*
 * MLM - I rather suspect that the following functions are an attempt to
 * foil the user that changes the dialog type of an existing selbox
 * widget; not all component widgets are created during initialization,
 * so if the dialog_type changes, the set_values method can invoke these
 * functions for the NULL components.
 */
extern void
_DtPrintSetupBoxCreateListLabel(DtPrintSetupBoxWidget sb)
{
    int ac;
    Arg al[2];

    if (SB_DialogType(sb) != XmDIALOG_COMMAND)
    {
	SB_ListLabel(sb) = _XmBB_CreateLabelG((Widget)sb,
					      SB_ListLabelString(sb),
					      "Items");
	ac = 0;
	XtSetArg(al[ac], XmNalignment, XmALIGNMENT_BEGINNING); ac++;
	XtSetValues(SB_ListLabel(sb), al, ac);
	XtManageChild(SB_ListLabel(sb));
    }
    else
    {
	SB_ListLabel(sb) = NULL;
    }
}


extern void
_DtPrintSetupBoxCreateSelectionLabel(DtPrintSetupBoxWidget sb)
{
    int ac;
    Arg al[2];

    SB_SelectionLabel(sb) = _XmBB_CreateLabelG((Widget)sb,
					       SB_SelectionLabelString(sb),
					       "Selection");
    ac = 0;
    XtSetArg(al[ac], XmNalignment, XmALIGNMENT_BEGINNING); ac++;
    XtSetValues(SB_SelectionLabel(sb), al, ac);
    XtManageChild(SB_SelectionLabel(sb));
}


extern void
_DtPrintSetupBoxCreateList(DtPrintSetupBoxWidget sb)
{
    int ac;
    Arg al[4];

    ac = 0;
    XtSetArg(al[ac], XmNvisibleItemCount, SB_ListVisibleItemCount(sb)); ac++;
    XtSetArg(al[ac], XmNselectionPolicy, XmBROWSE_SELECT); ac++;
    XtSetArg(al[ac], XmNlistSizePolicy, XmCONSTANT); ac++;
    XtSetArg(al[ac], XmNscrollBarDisplayPolicy, XmAS_NEEDED); ac++;
    SB_List(sb) = XmCreateScrolledList((Widget)sb, "ItemsList", al, ac);
    XtManageChild(SB_List(sb));

#if 0
    XtAddCallback(SB_List(sb), XmNsingleSelectionCallback, ListSingleSelect, sb);
    XtAddCallback(SB_List(sb), XmNbrowseSelectionCallback, ListSingleSelect, sb);
#endif
}

/*
 * _XmPsbOkCB
 */
static void
_XmPsbOkCB(Widget w, XtPointer client, XtPointer call)
{
	DtPrintSetupCallbackStruct	cbs;
	Widget				b = XtParent(w);
	XmPushButtonCallbackStruct	*cbp = (XmPushButtonCallbackStruct *)call;

	if (! XtIsSubclass(b, dtPrintSetupBoxWidgetClass))
		return;

	if (PSB_PrinterName(b) == NULL) {
		/* Should some warning be issued ? */
		return;
	}

	/* Select the printer, do all the necessary things */
	if (PSB_PrintSetupData(b)->printer_name) {
		XtFree(PSB_PrintSetupData(b)->printer_name);
		PSB_PrintSetupData(b)->printer_name = XtNewString(PSB_PrinterName(b));
	}

	/* This should do the hard work */
	DtPrintFillSetupData(b, PSB_PrintSetupData(b));

	/* Fill the callback structure */
	cbs.reason = DtPRINT_CR_PRINT;
	cbs.event = cbp->event;
	cbs.print_data = PSB_PrintSetupData(b);

	/* Call the callback list */
	XtCallCallbackList(b, PSB_PrintCallback(b), &cbs);
}

/*
 * _XmPsbSelectPrinterCB()
 *
 * Gets called by XmComboBox when the user selects a printer from the list.
 */
static void
_XmPsbSelectPrinterCB(Widget w, XtPointer client, XtPointer call)
{
	XmComboBoxCallbackStruct	*cbs = (XmComboBoxCallbackStruct *)call;
	Widget				b = XtParent(w);
	String				s = NULL;

	if (! XmStringGetLtoR(cbs->item_or_text, XmSTRING_DEFAULT_CHARSET, &s)) {
		return;
	}

	if (! XtIsSubclass(b, dtPrintSetupBoxWidgetClass))
		return;

	if (PSB_PrinterName(b))
		XtFree(PSB_PrinterName(b));
	PSB_PrinterName(b) = s;
}


extern void
_DtPrintSetupBoxCreateText(DtPrintSetupBoxWidget sb)
{
    int ac;
    Arg al[2];
    XtTranslations save_acc;

    ac = 0;
    XtSetArg(al[0], XmNnavigationType, XmSTICKY_TAB_GROUP); ac++;
    SB_Text(sb) = XmCreateTextField((Widget)sb, "Text", al, ac);
    save_acc = CoreAccelerators(sb);
    if (SB_TextAccelerators(sb) == NULL)
    {
	CoreAccelerators(sb) = text_accelerators_parsed;
    }
    else
    {
	CoreAccelerators(sb) = SB_TextAccelerators(sb);
    }
    XtInstallAccelerators(SB_Text(sb), (Widget) sb);
    CoreAccelerators(sb) = save_acc;
    XtManageChild(SB_Text(sb));
}


extern void
_DtPrintSetupBoxCreateButtonSeparator(DtPrintSetupBoxWidget sb)
{
    int ac;
    Arg al[2];

    ac = 0;
    XtSetArg(al[ac], XmNseparatorType, XmSHADOW_ETCHED_IN); ac++;
    XtSetArg(al[ac], XmNhighlightThickness, 0); ac++;
    PSB_BSeparator(sb) = XmCreateSeparatorGadget((Widget)sb, "ButtonSeparator", al, ac);
    XtManageChild(PSB_BSeparator(sb));
}


extern void
_DtPrintSetupBoxCreateBottomWorkAreaSeparator(DtPrintSetupBoxWidget sb)
{
    int ac;
    Arg al[2];

    ac = 0;
    XtSetArg(al[ac], XmNseparatorType, XmSHADOW_ETCHED_IN); ac++;
    XtSetArg(al[ac], XmNhighlightThickness, 0); ac++;
    PSB_BWASeparator(sb) = XmCreateSeparatorGadget((Widget)sb, "BottomWorkAreaSeparator", al, ac);
    XtManageChild(PSB_BWASeparator(sb));
}


extern void
_DtPrintSetupBoxCreateTopWorkAreaSeparator(DtPrintSetupBoxWidget sb)
{
    int ac;
    Arg al[2];

    ac = 0;
    XtSetArg(al[ac], XmNseparatorType, XmSHADOW_ETCHED_IN); ac++;
    XtSetArg(al[ac], XmNhighlightThickness, 0); ac++;
    PSB_TWASeparator(sb) = XmCreateSeparatorGadget((Widget)sb, "TopWorkAreaSeparator", al, ac);
    XtManageChild(PSB_TWASeparator(sb));
}


extern void
_DtPrintSetupBoxCreateOkButton(DtPrintSetupBoxWidget sb)
{
    SB_OkButton(sb) = _XmBB_CreateButtonG((Widget)sb, SB_OkLabelString(sb), "OK");
    XtManageChild(SB_OkButton(sb));
    XtRemoveAllCallbacks(SB_OkButton(sb), XmNactivateCallback);
    XtAddCallback(SB_OkButton(sb), XmNactivateCallback, _XmPsbOkCB, NULL);
}


extern void
_DtPrintSetupBoxCreateCancelButton(DtPrintSetupBoxWidget sb)
{
    BB_CancelButton(sb) = _XmBB_CreateButtonG((Widget)sb,
					      SB_CancelLabelString(sb),
					      "Cancel");
    XtManageChild(BB_CancelButton(sb));
#if 0
    XtRemoveAllCallbacks(SB_CancelButton(sb), XmNactivateCallback);
    XtAddCallback(BB_CancelButton(sb), XmNactivateCallback, _XmSbButton, NULL);
#endif
}


extern void
_DtPrintSetupBoxCreateCopiesSpinBox(DtPrintSetupBoxWidget sb)
{
    Widget	tf;
    int		ac = 0;
    Arg		al[4];

    PSB_CopiesSpinBox(sb) = XmCreateSpinBox((Widget)sb, "Copies", NULL, 0);
    XtManageChild(PSB_CopiesSpinBox(sb));

    XtSetArg(al[ac], XmNspinBoxChildType, XmNUMERIC); ac++;
    XtSetArg(al[ac], XmNdecimalPoints, 0); ac++;
    XtSetArg(al[ac], XmNminimumValue, 1); ac++;
    XtSetArg(al[ac], XmNmaximumValue, 1000); ac++;
    tf = XmCreateTextField(PSB_CopiesSpinBox(sb), "tf", al, ac);
    XtManageChild(tf);

#if 0
    XtAddCallback(SB_HelpButton(sb), XmNactivateCallback, _XmSbButton, NULL);
#endif
}


extern void
_DtPrintSetupBoxCreateCopiesLabel(DtPrintSetupBoxWidget sb)
{
/* Must find a way to have this in an un-hardcoded way FIX ME */
    Arg	a;
    XmString xms = XmStringCreateSimple("Copies : ");
    XtSetArg(a, XmNlabelString, xms);
    PSB_CopiesLabel(sb) = XmCreateLabelGadget((Widget)sb, "CopiesLabel", &a, 1);
    XtManageChild(PSB_CopiesLabel(sb));
    XmStringFree(xms);
}


void
_DtPrintSetupBoxCreateDescriptionLabel(DtPrintSetupBoxWidget sb)
{
    PSB_DescriptionLabel(sb) = XmCreateLabelGadget((Widget)sb, "DescriptionLabel", NULL, 0);
    XtManageChild(PSB_DescriptionLabel(sb));
}


void
_DtPrintSetupBoxCreateFileName(DtPrintSetupBoxWidget sb)
{
    PSB_FileNameTF(sb) = XmCreateTextField(PSB_FileNameCheckBox(sb), "FileName", NULL, 0);
    XtManageChild(PSB_FileNameTF(sb));
}


void
_DtPrintSetupBoxCreateFileNameCheckBox(DtPrintSetupBoxWidget sb)
{
    Arg	al[5];
    int	ac = 0;

    XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;	/* ?? FIX ME */
    PSB_FileNameCheckBox(sb) = XmCreateRowColumn((Widget)sb, "FileNameCheckBox", al, ac);
    XtManageChild(PSB_FileNameCheckBox(sb));
}


void
_DtPrintSetupBoxCreateInfoButton(DtPrintSetupBoxWidget sb)
{
    PSB_InfoButton(sb) = XmCreatePushButtonGadget((Widget)sb, "Info", NULL, 0);
    XtManageChild(PSB_InfoButton(sb));
    XtRemoveAllCallbacks(PSB_InfoButton(sb), XmNactivateCallback);
}


void
_DtPrintSetupBoxCreateName(DtPrintSetupBoxWidget sb)
{
	Widget	w = (Widget)sb;

	PSB_NameComboBox(sb) = XmCreateComboBox(w, "Name", NULL, 0);
	XtManageChild(PSB_NameComboBox(w));
	XtAddCallback(PSB_NameComboBox(w), XmNselectionCallback, _XmPsbSelectPrinterCB, NULL);
}


extern void
_DtPrintSetupBoxCreateHelpButton(DtPrintSetupBoxWidget sb)
{
    SB_HelpButton(sb) = _XmBB_CreateButtonG((Widget)sb,
					    SB_HelpLabelString(sb),
					    "Help");
    XtManageChild(SB_HelpButton(sb));
    /* get rid of auto_unmanage */
    XtRemoveAllCallbacks(SB_HelpButton(sb), XmNactivateCallback);

#if 0
    XtAddCallback(SB_HelpButton(sb), XmNactivateCallback, _XmSbButton, NULL);
#endif
}


static void _DtPrintSetupBoxCreateNameLabel(DtPrintSetupBoxWidget sb)
{
}


static void _DtPrintSetupBoxCreateSelectFileButton(DtPrintSetupBoxWidget sb)
{
    PSB_SelectFileButton(sb) = _XmBB_CreateButtonG((Widget)sb,
					    PSB_SelectFileLabelString(sb),
					    "Select File");
    XtManageChild(PSB_SelectFileButton(sb));
    XtRemoveAllCallbacks(PSB_SelectFileButton(sb), XmNactivateCallback);
}


static void _DtPrintSetupBoxCreateSelectPrinterButton(DtPrintSetupBoxWidget sb)
{
    PSB_SelectPrinterButton(sb) = _XmBB_CreateButtonG((Widget)sb,
					    PSB_SelectPrinterLabelString(sb),
					    "Select Printer");
    XtManageChild(PSB_SelectPrinterButton(sb));
    XtRemoveAllCallbacks(PSB_SelectPrinterButton(sb), XmNactivateCallback);
}


static void _DtPrintSetupBoxCreateSetupButton(DtPrintSetupBoxWidget sb)
{
    PSB_SetupButton(sb) = _XmBB_CreateButtonG((Widget)sb,
					    PSB_SetupLabelString(sb),
					    "Setup ...");
    XtManageChild(PSB_SetupButton(sb));
    XtRemoveAllCallbacks(PSB_SetupButton(sb), XmNactivateCallback);
}


/*
 * I believe that most of the following are for syn_resource export procs
 */
extern void
_DtPrintSetupBoxGetSelectionLabelString(Widget wid, int resource_offset,
				       XtArgVal *value)
{
}


extern void
_DtPrintSetupBoxGetListLabelString(Widget wid, int resource_offset,
				  XtArgVal *value)
{
}


extern void
_DtPrintSetupBoxGetTextColumns(Widget wid, int resource_offset,
			      XtArgVal *value)
{
    Arg a;
    int n;

    DEBUGOUT(XdbDebug(__FILE__, wid, "DtPrintSetupBoxGettTextColumns\n"));

    XtSetArg(a, XmNtextColumns, &n);
    n = -1;
    XtGetValues(SB_Text(wid), &a, 1);

    /* Should this be a copy or the real thing ?? */
    *value = (XtArgVal)n;
}


extern void
_DtPrintSetupBoxGetTextString(Widget wid, int resource_offset,
			     XtArgVal *value)
{
    char *str;

    DEBUGOUT(XdbDebug(__FILE__, wid, "_DtPrintSetupBoxGetTextString\n"));

    str = XmTextFieldGetString(SB_Text(wid));
    *value = (XtArgVal)XmStringCreateSimple(str);
    XtFree(str);
}


extern void
_DtPrintSetupBoxGetListItems(Widget wid, int resource_offset,
			    XtArgVal *value)
{
    XmStringTable l;
    Arg a;

    DEBUGOUT(XdbDebug(__FILE__, wid,
		      "DtPrintSetupBoxGetListItems(_, %d, _)\n",
		      resource_offset));

    XtSetArg(a, XmNitems, &l);
    l = NULL;
    XtGetValues(SB_List(wid), &a, 1);

    /* Should this be a copy or the real thing ?? */
    /* MLM: This (I think) should be a copy, as the user might free it. Unless
     * the List doesn't make a copy when you do the GetValues call.  You
     * probably could use the access macros from ListP.h and make a copy of
     * that, for better code efficiency.  Also, remember that if the List has
     * a Synthetic resource for ListItems, and it makes a copy, then you've
     * got a copy already if you've used XtGetValues()...
     */

    *value = (XtArgVal)l;
}


extern void
_DtPrintSetupBoxGetListItemCount(Widget wid, int resource_offset,
				XtArgVal *value)
{
    Arg a;
    int n;

    DEBUGOUT(XdbDebug(__FILE__, wid, "DtPrintSetupBoxGetListItemCount\n"));

    XtSetArg(a, XmNitemCount, &n);
    n = -1;
    XtGetValues(SB_List(wid), &a, 1);
    /* Should this be a copy or the real thing ?? */
    /* MLM: I don't think this matters here.  Except that you may want to use
     * the access macros from ListP.h, and avoid the GetValues overhead.
     */
    *value = (XtArgVal)n;
}


extern void
_DtPrintSetupBoxGetListVisibleItemCount(Widget wid, int resource_offset,
				       XtArgVal *value)
{
}


extern void
_DtPrintSetupBoxGetOkLabelString(Widget wid, int resource_offset,
				XtArgVal *value)
{
}


extern void
_DtPrintSetupBoxGetCancelLabelString(Widget wid, int resource_offset,
				    XtArgVal *value)
{
}


extern void
_DtPrintSetupBoxGetHelpLabelString(Widget wid, int resource_offset,
				  XtArgVal *value)
{
}


extern XmGeoMatrix
_DtPrintSetupBoxGeoMatrixCreate(Widget _w, Widget _from, XtWidgetGeometry *_pref)
{
    XmGeoMatrix geoSpec;
    register XmGeoRowLayout layoutPtr;
    register XmKidGeometry boxPtr;
    Cardinal numKids;
    Boolean newRow;
    int nrows, i, nextras;
    Widget *extras;

    numKids = MGR_NumChildren(_w);

    nextras = 0;
    extras = NULL;
    for (i = 0; i < numKids; i++)
    {
	/*
	 * There seems to be no way to add a button to the button area
	 * without first managing a child in the work area. Motif allows
	 * me to create an "unmanaged" child in the work area so that extra
	 * buttons will be in the proper place. -- rws
	 */
	if (MGR_Children(_w)[i] != SB_ListLabel(_w) &&
	    (SB_List(_w)
	     ? MGR_Children(_w)[i] != XtParent(SB_List(_w))
	     : True) &&
	    MGR_Children(_w)[i] != SB_SelectionLabel(_w) &&
	    MGR_Children(_w)[i] != SB_Text(_w) &&
	    MGR_Children(_w)[i] != SB_Separator(_w) &&
	    MGR_Children(_w)[i] != SB_OkButton(_w) &&
	    MGR_Children(_w)[i] != SB_HelpButton(_w) &&
	    MGR_Children(_w)[i] != BB_CancelButton(_w))
	{
	    nextras++;
	}
    }

    if (nextras)
    {
	extras = (Widget *)XtMalloc(sizeof(Widget) * nextras);
    }

    nextras = 0;
    for (i = 0; i < numKids; i++)
    {
	if (MGR_Children(_w)[i] != SB_ListLabel(_w) &&
	    (SB_List(_w)
	     ? MGR_Children(_w)[i] != XtParent(SB_List(_w))
	     : True) &&
	    MGR_Children(_w)[i] != SB_SelectionLabel(_w) &&
	    MGR_Children(_w)[i] != SB_Text(_w) &&
	    MGR_Children(_w)[i] != SB_Separator(_w) &&
	    MGR_Children(_w)[i] != SB_OkButton(_w) &&
	    MGR_Children(_w)[i] != SB_HelpButton(_w) &&
	    MGR_Children(_w)[i] != BB_CancelButton(_w))
	{
	    extras[nextras] = MGR_Children(_w)[i];
	    nextras++;
	}
    }

    nrows = 0;

    /* note the starting from one.  The zero'th child is the "work area" */
    if (nextras > 0)
    {
	for (i = 1; i < nextras; i++)
	{
	    if (XmIsMenuBar(extras[i]) && XtIsManaged(extras[i]))
		nrows++;
	}
	if (extras[0] && XtIsManaged(extras[0]))
	    nrows++;
    }

    if (SB_ListLabel(_w) && XtIsManaged(SB_ListLabel(_w))) {
	nrows++;
    }

    if (SB_List(_w) && XtIsManaged(SB_List(_w))) {
	nrows++;
    }

    if (SB_SelectionLabel(_w) && XtIsManaged(SB_SelectionLabel(_w))) {
	nrows++;
    }

    if (SB_Text(_w) && XtIsManaged(SB_Text(_w)))
    {
	nrows++;
    }

    if (SB_Separator(_w) && XtIsManaged(SB_Separator(_w))) {
	nrows++;
    }

	if (PSB_BSeparator(_w) && XtIsManaged(PSB_BSeparator(_w)))
		nrows++;
	if (PSB_TWASeparator(_w) && XtIsManaged(PSB_TWASeparator(_w)))
		nrows++;
	if (PSB_BWASeparator(_w) && XtIsManaged(PSB_BWASeparator(_w)))
		nrows++;

    if ((BB_CancelButton(_w) && XtIsManaged(BB_CancelButton(_w))) ||
	(SB_OkButton(_w) && XtIsManaged(SB_OkButton(_w))) ||
	(SB_HelpButton(_w) && XtIsManaged(SB_HelpButton(_w))))
    {
	nrows++;
    }
    else
    {
	for (i = 1; i < nextras; i++)
	{
	    if (extras[i] && XtIsManaged(extras[i]) &&
		(XmIsPushButton(extras[i]) || XmIsPushButtonGadget(extras[i])))
	    {
		nrows++;
		break;
	    }
	}
    }

    geoSpec = _XmGeoMatrixAlloc(nrows, numKids, 0);
    geoSpec->composite = (Widget)_w;
    geoSpec->instigator = (Widget)_from;
    if (_pref)
    {
	geoSpec->instig_request = *_pref;
    }
    geoSpec->margin_w = BB_MarginWidth(_w) + MGR_ShadowThickness(_w);
    geoSpec->margin_h = BB_MarginHeight(_w) + MGR_ShadowThickness(_w);
    geoSpec->no_geo_request = _DtPrintSetupBoxNoGeoRequest;

    layoutPtr = &(geoSpec->layouts->row);
    boxPtr = geoSpec->boxes;

    for (i = 1; i < nextras; i++)
    {
	if (XmIsMenuBar(extras[i]) && XtIsManaged(extras[i]) &&
	    _XmGeoSetupKid(boxPtr, extras[i]))
	{
	    layoutPtr->fix_up = _XmMenuBarFix;
	    layoutPtr->space_above = 0;
	    boxPtr += 2;
	    layoutPtr++;
	    break;
	}
    }

    if (SB_ChildPlacement(_w) == XmPLACE_TOP && nextras &&
	extras[0] && XtIsManaged(extras[0]) &&
	_XmGeoSetupKid(boxPtr, extras[0]))
    {
	layoutPtr->stretch_height = 1;
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->even_width = 1;
	layoutPtr->even_height = 1;
	layoutPtr->space_above = BB_MarginHeight(_w);
	layoutPtr++;
	boxPtr += 2;
	nrows++;
    }

    if (SB_DialogType(_w) == XmDIALOG_PROMPT &&
	SB_ChildPlacement(_w) == XmPLACE_ABOVE_SELECTION && nextras &&
	extras[0] && XtIsManaged(extras[0]) &&
	_XmGeoSetupKid(boxPtr, extras[0]))
    {
	layoutPtr->stretch_height = 1;
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->even_width = 1;
	layoutPtr->even_height = 1;
	layoutPtr->space_above = BB_MarginHeight(_w);
	layoutPtr++;
	boxPtr += 2;
	nrows++;
    }

    newRow = False;
    if (SB_ListLabel(_w) && XtIsManaged(SB_ListLabel(_w)) &&
	_XmGeoSetupKid(boxPtr, SB_ListLabel(_w)))
    {
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->fit_mode = XmGEO_PROPORTIONAL;
	layoutPtr->even_width = 1;
	layoutPtr->even_height = 1;
	layoutPtr->space_above = BB_MarginHeight(_w);
	layoutPtr->space_between = BB_MarginWidth(_w);
	newRow = True;
	boxPtr++;
    }

    if (newRow)
    {
	layoutPtr++;
	boxPtr++;
    }

    if (SB_DialogType(_w) == XmDIALOG_COMMAND &&
	SB_ChildPlacement(_w) == XmPLACE_ABOVE_SELECTION && nextras &&
	extras[0] && XtIsManaged(extras[0]) &&
	_XmGeoSetupKid(boxPtr, extras[0]))
    {
	layoutPtr->stretch_height = 1;
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->even_width = 1;
	layoutPtr->even_height = 1;
	layoutPtr->space_above = BB_MarginHeight(_w);
	layoutPtr++;
	boxPtr += 2;
	nrows++;
    }

    newRow = False;
    if (SB_List(_w) && XtIsManaged(SB_List(_w)) &&
	_XmGeoSetupKid(boxPtr, XtParent(SB_List(_w))))
    {
	layoutPtr->stretch_height = 1;
	layoutPtr->min_height = 40;
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->fit_mode = XmGEO_PROPORTIONAL;
	layoutPtr->even_width = 1;
	layoutPtr->even_height = 1;
	layoutPtr->space_above = 0;	/* BB_MarginHeight(_w); */
	layoutPtr->space_between = BB_MarginWidth(_w);
	newRow = True;
	boxPtr++;
    }

    if (newRow)
    {
	layoutPtr++;
	boxPtr++;
    }

    if (SB_DialogType(_w) != XmDIALOG_COMMAND &&
	SB_DialogType(_w) != XmDIALOG_PROMPT &&
	SB_ChildPlacement(_w) == XmPLACE_ABOVE_SELECTION && nextras &&
	extras[0] && XtIsManaged(extras[0]) &&
	_XmGeoSetupKid(boxPtr, extras[0]))
    {
	layoutPtr->stretch_height = 1;
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->even_width = 1;
	layoutPtr->even_height = 4;
	layoutPtr->space_above = BB_MarginHeight(_w);
	layoutPtr++;
	boxPtr += 2;
	nrows++;
    }

    if (SB_SelectionLabel(_w) && XtIsManaged(SB_SelectionLabel(_w)) &&
	_XmGeoSetupKid(boxPtr, SB_SelectionLabel(_w)))
    {
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->even_width = 0;
	layoutPtr->even_height = 1;
	layoutPtr->space_above = BB_MarginHeight(_w);
	layoutPtr++;
	boxPtr += 2;
    }

    if (SB_Text(_w) && XtIsManaged(SB_Text(_w)) &&
	_XmGeoSetupKid(boxPtr, SB_Text(_w)))
    {
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->even_height = 1;
	layoutPtr->even_width = 0;
	layoutPtr->space_above = 0;	/* BB_MarginHeight(_w); */
	boxPtr += 2;
	layoutPtr++;
    }

    if (SB_ChildPlacement(_w) == XmPLACE_BELOW_SELECTION && nextras &&
	extras[0] && XtIsManaged(extras[0]) &&
	_XmGeoSetupKid(boxPtr, extras[0]))
    {
	layoutPtr->stretch_height = 1;
	layoutPtr->fill_mode = XmGEO_EXPAND;
	layoutPtr->even_width = 1;
	layoutPtr->even_height = 1;
	layoutPtr->space_above = BB_MarginHeight(_w);
	layoutPtr++;
	boxPtr += 2;
	nrows++;
    }

    if (SB_Separator(_w) && XtIsManaged(SB_Separator(_w)) &&
	_XmGeoSetupKid(boxPtr, SB_Separator(_w)))
    {
	layoutPtr->fix_up = _XmSeparatorFix;
	layoutPtr->space_above = BB_MarginHeight(_w);
	boxPtr += 2;
	layoutPtr++;
    }

    newRow = False;
    if (SB_OkButton(_w) && XtIsManaged(SB_OkButton(_w)) &&
	_XmGeoSetupKid(boxPtr++, SB_OkButton(_w)))
    {
	layoutPtr->fill_mode = XmGEO_CENTER;
	layoutPtr->fit_mode = XmGEO_WRAP;
	layoutPtr->even_width = 6;
	layoutPtr->even_height = 6;
	layoutPtr->space_above = BB_MarginHeight(_w);
	newRow = True;
    }
    for (i = 1; i < nextras; i++)
    {
	if (extras[i] && XtIsManaged(extras[i]) &&
	    (XmIsPushButton(extras[i]) || XmIsPushButtonGadget(extras[i])) &&
	    _XmGeoSetupKid(boxPtr++, extras[i]))
	{
	    _XmBulletinBoardSetDefaultShadow(extras[i]);
	    layoutPtr->fill_mode = XmGEO_CENTER;
	    layoutPtr->fit_mode = XmGEO_WRAP;
	    layoutPtr->even_width = 6;
	    layoutPtr->even_height = 6;
	    layoutPtr->space_above = BB_MarginHeight(_w);
	    newRow = True;
	}
    }

    if (PSB_InfoButton(_w) && XtIsManaged(PSB_InfoButton(_w)) &&
	_XmGeoSetupKid(boxPtr++, PSB_InfoButton(_w)))
    {
	layoutPtr->fill_mode = XmGEO_CENTER;
	layoutPtr->fit_mode = XmGEO_WRAP;
	layoutPtr->even_width = 6;
	layoutPtr->even_height = 6;
	layoutPtr->space_above = BB_MarginHeight(_w);
	newRow = True;
    }
    if (BB_CancelButton(_w) && XtIsManaged(BB_CancelButton(_w)) &&
	_XmGeoSetupKid(boxPtr++, BB_CancelButton(_w)))
    {
	layoutPtr->fill_mode = XmGEO_CENTER;
	layoutPtr->fit_mode = XmGEO_WRAP;
	layoutPtr->even_width = 6;
	layoutPtr->even_height = 6;
	layoutPtr->space_above = BB_MarginHeight(_w);
	newRow = True;
    }
    if (SB_HelpButton(_w) && XtIsManaged(SB_HelpButton(_w)) &&
	_XmGeoSetupKid(boxPtr++, SB_HelpButton(_w)))
    {
	layoutPtr->fill_mode = XmGEO_CENTER;
	layoutPtr->fit_mode = XmGEO_WRAP;
	layoutPtr->even_width = 6;
	layoutPtr->even_height = 6;
	layoutPtr->space_above = BB_MarginHeight(_w);
	newRow = True;
    }

    if (newRow)
    {
	layoutPtr++;
	boxPtr++;
    }

/* Added for now */
    if (PSB_BSeparator(_w) && XtIsManaged(PSB_BSeparator(_w)) &&
	_XmGeoSetupKid(boxPtr, PSB_BSeparator(_w)))
    {
	layoutPtr->fix_up = _XmSeparatorFix;
	layoutPtr->space_above = BB_MarginHeight(_w);
	boxPtr += 2;
	layoutPtr++;
    }

    newRow = False;
    if (PSB_NameComboBox(_w) && XtIsManaged(PSB_NameComboBox(_w)) &&
	_XmGeoSetupKid(boxPtr++, PSB_NameComboBox(_w))) {
	
	layoutPtr->fill_mode = XmGEO_CENTER;
	layoutPtr->fit_mode = XmGEO_WRAP;
	layoutPtr->even_width = 6;
	layoutPtr->even_height = 6;
	layoutPtr->space_above = BB_MarginHeight(_w);
	newRow = True;
    }
    if (PSB_CopiesLabel(_w) && XtIsManaged(PSB_CopiesLabel(_w)) &&
	_XmGeoSetupKid(boxPtr++, PSB_CopiesLabel(_w))) {
	
	layoutPtr->fill_mode = XmGEO_CENTER;
	layoutPtr->fit_mode = XmGEO_WRAP;
	layoutPtr->even_width = 6;
	layoutPtr->even_height = 6;
	layoutPtr->space_above = BB_MarginHeight(_w);
	newRow = True;
    }
    if (PSB_CopiesSpinBox(_w) && XtIsManaged(PSB_CopiesSpinBox(_w)) &&
	_XmGeoSetupKid(boxPtr++, PSB_CopiesSpinBox(_w))) {
	
	layoutPtr->fill_mode = XmGEO_CENTER;
	layoutPtr->fit_mode = XmGEO_WRAP;
	layoutPtr->even_width = 6;
	layoutPtr->even_height = 6;
	layoutPtr->space_above = BB_MarginHeight(_w);
	newRow = True;
    }
    if (PSB_DescriptionLabel(_w) && XtIsManaged(PSB_DescriptionLabel(_w)) &&
	_XmGeoSetupKid(boxPtr++, PSB_DescriptionLabel(_w))) {
	
	layoutPtr->fill_mode = XmGEO_CENTER;
	layoutPtr->fit_mode = XmGEO_WRAP;
	layoutPtr->even_width = 6;
	layoutPtr->even_height = 6;
	layoutPtr->space_above = BB_MarginHeight(_w);
	newRow = True;
    }
    if (PSB_FileNameCheckBox(_w) && XtIsManaged(PSB_FileNameCheckBox(_w)) &&
	_XmGeoSetupKid(boxPtr++, PSB_FileNameCheckBox(_w))) {
	
	layoutPtr->fill_mode = XmGEO_CENTER;
	layoutPtr->fit_mode = XmGEO_WRAP;
	layoutPtr->even_width = 6;
	layoutPtr->even_height = 6;
	layoutPtr->space_above = BB_MarginHeight(_w);
	newRow = True;
    }

    if (newRow) {
	layoutPtr++;
	boxPtr++;
    }
/* End added for now */

    layoutPtr->space_above = 0;	/* BB_MarginHeight(_w); */
    layoutPtr->end = True;
    if (nextras)
    {
	XtFree((char *)extras);
    }
    return (geoSpec);
}


extern Boolean
_DtPrintSetupBoxNoGeoRequest(XmGeoMatrix _geoSpec)
{
    if (BB_InSetValues(_geoSpec->composite) &&
	(XtClass(_geoSpec->composite) == xmSelectionBoxWidgetClass ||
	 XtClass(_geoSpec->composite) == xmCommandWidgetClass))
    {
	return True;
    }

    return False;
}


extern Widget
DtCreatePrintSetupBox(Widget parent,
		const String name,
		ArgList arglist,
		Cardinal argcount)
{
    return XtCreateWidget(name, dtPrintSetupBoxWidgetClass, parent,
			  arglist, argcount);
}


extern Widget
DtCreatePrintSetupDialog(Widget parent, char *name,
			Arg *argList, Cardinal argcount)
{
    Widget d, r;
    char *s;
    Arg *al = (Arg *)XtCalloc(argcount + 1, sizeof(Arg));
    int ac, i;

    s = _XmMakeDialogName(name);

    ac = 0;
    XtSetArg(al[ac], XmNallowShellResize, True); ac++;
    for (i = 0; i < argcount; i++)
    {
	XtSetArg(al[ac], argList[i].name, argList[i].value); ac++;
    }

    d = XmCreateDialogShell(parent, s, al, ac);
    XtFree(s);

    r = XtCreateWidget(name, dtPrintSetupBoxWidgetClass, d, al, ac);
    XtFree((XtPointer)al);
    return r;
}


extern Widget
DtPrintSetupBoxGetChild(Widget w, unsigned char child)
{
    DtPrintSetupBoxWidget sb = (DtPrintSetupBoxWidget)w;

    switch (child)
    {
    case XmDIALOG_CANCEL_BUTTON:
	return BB_CancelButton(sb);

    case XmDIALOG_OK_BUTTON:
	return SB_OkButton(sb);

    case XmDIALOG_FILTER_TEXT:
	return BB_CancelButton(sb);

    case XmDIALOG_HELP_BUTTON:
	return SB_HelpButton(sb);

    case XmDIALOG_LIST:
	return SB_List(sb);

    case XmDIALOG_SEPARATOR:
	return SB_Separator(sb);

    case XmDIALOG_TEXT:
	return SB_Text(sb);

    case XmDIALOG_LIST_LABEL:
	return SB_ListLabel(sb);

    case XmDIALOG_MESSAGE_LABEL:
	return NULL;

    case XmDIALOG_SELECTION_LABEL:
	return SB_SelectionLabel(sb);

    case XmDIALOG_SYMBOL_LABEL:
	return NULL;

    case XmDIALOG_FILTER_LABEL:
	return NULL;

    case XmDIALOG_DIR_LIST:
	return NULL;

    case XmDIALOG_DIR_LIST_LABEL:
	return NULL;

    case XmDIALOG_DEFAULT_BUTTON:
	return BB_DefaultButton(sb);

	/* These are illegal */
    case XmDIALOG_NONE:
    default:
	return NULL;
    }
}


/*      
 * Keep track of button children
 */
static void
insert_child(Widget w)
{
#define superclass      (&xmBulletinBoardClassRec)
    (*superclass->composite_class.insert_child) (w);
#undef  superclass
}


static void
DeleteChild(Widget w)
{
	Widget	sb = XtParent(w);

#define superclass      (&xmBulletinBoardClassRec)
    (*superclass->composite_class.delete_child) (w);
#undef  superclass

	if (w == SB_HelpButton(sb))
		SB_HelpButton(sb) = NULL;
	if (w == SB_OkButton(sb))
		SB_OkButton(sb) = NULL;
	if (w == SB_Separator(sb))
		SB_Separator(sb) = NULL;
	if (w == SB_Text(sb))
		SB_Text(sb) = NULL;
	if (w == SB_SelectionLabel(sb))
		SB_SelectionLabel(sb) = NULL;
	if (w == SB_List(sb))
		SB_List(sb) = NULL;
	if (w == SB_WorkArea(sb))
		SB_WorkArea(sb) = NULL;
	if (w == SB_ListLabel(sb))
		SB_ListLabel(sb) = NULL;
}


static void
_XmDialogTypeDefault(Widget w, int offset, XrmValue *value)
{
    static unsigned char dialog_type;
    
    DEBUGOUT(XdbDebug(__FILE__, w, "_XmDialogTypeDefault\n"));
    
    dialog_type = XmDIALOG_WORK_AREA;
    
    value->addr = (char *) &dialog_type;
    value->size = sizeof (unsigned char);
    
    if (XmIsDialogShell(XtParent(w)))
    {
	dialog_type = XmDIALOG_SELECTION;
    }
}


/*
 * These functions are the default ones
 */
/*
 * For DtNprinterInfoProc
 *
 * Get printer information.
 * Also called from default DtNselectPrinterProc.
 * If DtNprintSetupMode == DtPRINT_SETUP_XP, pop up a dialog showing the info.
 * Don't update the calling widget.
 */
static void
_DtDefaultPrinterInfoProc(Widget w, DtPrintSetupData *print_data)
{
	DtPrintSetupBoxWidget	dw = (DtPrintSetupBoxWidget)w;
	XPPrinterList		plist;
	int			count, ac;
	Arg			al[5];
	XmString		xms;
	Widget			mb;

	if (PSB_PrintSetupMode(w) != DtPRINT_SETUP_XP)
		return;

	if (print_data == 0 || print_data->print_display == 0 || print_data->printer_name == 0)
		return;

	if (print_data->dest_info) {
		XtFree(print_data->dest_info);
		print_data->dest_info = 0;
	}

	/* Must we look at print_data->destination (DtPRINT_TO_PRINTER, DtPRINT_TO_FILE) ? */

	/* Figure out the information */
	plist = XpGetPrinterList(print_data->print_display, print_data->printer_name, &count);
	if (plist == 0 || count <= 0)
		return;

	/* What to do with more than one entry in the list ? */
	print_data->dest_info = XtNewString(plist[0].desc);

	/* Show it */
	ac = 0;
	xms = XmStringCreateSimple(print_data->dest_info);
	XtSetArg(al[ac], XmNmessageString, xms); ac++;
	mb = XmCreateMessageDialog(XtParent(w), "printer info", al, ac);
	XtDestroyWidget(XmMessageBoxGetChild(mb, XmDIALOG_HELP_BUTTON));
	XtDestroyWidget(XmMessageBoxGetChild(mb, XmDIALOG_CANCEL_BUTTON));
	XtManageChild(mb);
	XmStringFree(xms);
}


/* For DtNselectFileProc */
static void
_DtDefaultSelectFileProc(Widget w, DtPrintSetupData *print_data)
{
	fprintf(stderr, "_DtDefaultSelectFileProc()\n");
}


static void
_DtSelectPrinterOkCB(Widget w, XtPointer client, XtPointer call)
{
	Widget	d;

	XtVaSetValues(w, DtNprinterName, "this is the printer", NULL);
}


/* For DtNselectPrinterProc */
/*
 * This is called in response to the activation of the Select Printer button.
 * If DtNprintSetupMode is DtPRINT_SETUP_XP, pops up a dialog to ask the user
 * to select a printer.
 * If the user presses cancel, nothing is updated; otherwise DtNprinterName
 * is set.
 */
static void
_DtDefaultSelectPrinterProc(Widget w, DtPrintSetupData *print_data)
{
	Widget		d;
	Arg		al[5];
	int		ac = 0;

	fprintf(stderr, "_DtDefaultSelectPrinterProc()\n");

	if (PSB_PrintSetupMode(w) != DtPRINT_SETUP_XP)
		return;

	PSB_PrinterSelectionDialog(w) = d = XmCreateSelectionDialog(w, "select printer", al, ac);
	XtDestroyWidget(XmSelectionBoxGetChild(d, XmDIALOG_APPLY_BUTTON));
	XtManageChild(d);
	XtAddCallback(d, XmNokCallback, _DtSelectPrinterOkCB, (XtPointer)w);
}


/* For DtNsetupProc */
static void
_DtDefaultSetupProc(Widget w, DtPrintSetupData *print_data)
{
	fprintf(stderr, "_DtDefaultSetupProc()\n");
}


/* For DtNverifyPrinterProc */
/*
 * Verify the printer name prior to any operation on it.
 */
static void
_DtDefaultVerifyPrinterProc(Widget w, DtPrintSetupData *print_data)
{
	fprintf(stderr, "_DtDefaultVerifyPrinterProc()\n");
}


static void
_DtPsbAddToPrinterList(Widget w, Display *d)
{
	XPPrinterList	plist;
	int		count, i, a = 0, b = 0;
	XmString	xms;

	if (! XpQueryExtension(d, &a, &b))
		return;	/* This display doesn't support the X Printing Extension */

	plist = XpGetPrinterList(d, "", &count);
	for (i=0; i<count; i++) {
		xms = XmStringCreateSimple(plist[i].name);
		XmComboBoxAddItem(PSB_NameComboBox(w), xms, 0, 0);	/* FIX ME */
	}
}

/*
 * Don't know how this should happen FIX ME
 * Get a list of printers through libXp and put it in the combobox.
 */
static void
_DtPsbUpdatePrinterList(Widget w)
{
	char	*p, *q, *z, *d, *list;
	String	argv[] = { "this" };
	int	argc = 1;
	Display	*pdpy;

	/* Lots of info in PSB_PrintSetupData(w) */
	if (PSB_PrintSetupData(w)->print_display)
		_DtPsbAddToPrinterList(w, PSB_PrintSetupData(w)->print_display);

	/* Check this display */
	_DtPsbAddToPrinterList(w, XtDisplay(w));

	/* Check the list of print servers */
	list = getenv("XPSERVERLIST");
	if (list) {
		DEBUGOUT(XdbDebug(__FILE__, w, "Try XpServerlist [%s]\n", list));
		z = XtMalloc(strlen(list)+5);
		/* Cut the list into pieces */
		for (p=list; *p; p++) {
			while (*p && isspace(*p)) p++;
			if (*p == '\0')
				break;
			for (q=p, d=z; *q && !isspace(*q); q++)
				*(d++) = *q;
			*d = '\0';

			/* Now z contains a piece of the list */
			if (! strchr(z, ':'))
				strcat(z, ":0");
			DEBUGOUT(XdbDebug(__FILE__, w, "_DtPsbUpdatePrinterList try to open display <%s>\n", z));
			pdpy = XtOpenDisplay(XtWidgetToApplicationContext(w),
				z, "", "", NULL, 0, &argc, argv);
			if (pdpy)
				_DtPsbAddToPrinterList(w, pdpy);

			if (*q)
				p=q;
			else
				break;
		}
		XtFree(z);
	}
}
