/**
 * 
 * $Header: /cvsroot/lesstif/lesstif/include/Motif-2.1/Xm/PrintSP.h,v 1.1 2000/11/08 21:17:58 dannybackx Exp $
 *
 * Copyright  2000 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef XM_PRINT_P_H
#define XM_PRINT_P_H

#include <Xm/Xm.h>
#include <X11/ShellP.h>

#ifdef __cplusplus
extern "C" {
#endif

/* New fields for the XmPrintShell widget class record */

typedef struct {
    XtPointer       extension;          /* pointer to extension record      */
} XmPrintShellClassPart;

typedef struct XmPrintShellClassRec {
  	CoreClassPart      core_class;
	CompositeClassPart composite_class;
	ShellClassPart  shell_class;
	WMShellClassPart   wm_shell_class;
	VendorShellClassPart vendor_shell_class;
	TopLevelShellClassPart top_level_shell_class;
	ApplicationShellClassPart application_shell_class;
	XmPrintShellClassPart print_shell_class;
} XmPrintShellClassRec;

extern XmPrintShellClassRec xmPrintShellClassRec;

/* New fields for the XmPrint shell widget */

typedef struct {
    XtCallbackList	start_job_callback,
			end_job_callback,
			page_setup_callback,
			pdm_notification_callback;
    Dimension		min_x,
			min_y,
			max_x,
			max_y;
    unsigned short	default_pixmap_resolution;
} XmPrintShellPart;

typedef  struct {
	CorePart 	core;
	CompositePart 	composite;
	ShellPart 	shell;
	WMShellPart	wm;
	VendorShellPart	vendor;
	TopLevelShellPart topLevel;
	ApplicationShellPart application;
	XmPrintShellPart print_shell;
} XmPrintShellRec, *XmPrintShellWidget;
extern WidgetClass xmPrintShellWidgetClass;

#ifdef __cplusplus
}
#endif

#endif
