/** gmtoff.c - get time zone offset in seconds
 * (C) 2001 - 2002 by Matthias Andree
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 or 2.1 of
 * the License. See the file COPYING.LGPL for details.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "leafnode.h"

/* for abort(3) */
#include <stdlib.h>

/* for memcpy(3) */
#include <string.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif

/** Returns number of seconds the local time zone is ahead (east) of
 * UTC, for the given time. */
time_t
gmtoff(const time_t t1)
{
    time_t t2;
    struct tm *t, myt;

    t = gmtime(&t1);
    if (t != NULL) {
	memcpy(&myt, t, sizeof(struct tm));
	myt.tm_isdst = -1;
	t2 = mktime(&myt);
    } else {
	/* must not happen, is a SUSv2 violation */
	abort();
    }

    return t1 - t2;
}
