/*
lsort - re-sort groupinfo files from versions prior to 1.9.3

Written and Copyright 1999 by Joerg Dietrich <joerg@dietrich.net>
Modified and copyright of the modifications 2002 by Ralf Wildenhues
<ralf.wildenhues@gmx.de>.

See file COPYING for restrictions on the use of this software.
*/

#include "leafnode.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

int verbose = 0;
int debug = 0;

static int
comp(const void *a, const void *b)
{
    return strcasecmp(*(const char *const *)a, *(const char *const *)b);
}

int
main(void)
{
    char *l;
    char path[PATH_MAX]; /* RATS: ignore */
    char **act;
    unsigned long acount = 0;
    unsigned long i;
    FILE *f;

    xsnprintf(path, sizeof(path), "%s/leaf.node/groupinfo.old", spooldir);

    f = fopen(path, "r");
    if (f == NULL) {
	fprintf(stderr, "Error: Can't open groupinfo.old!\n");
	exit(1);
    }

    act = (char **)critmalloc(sizeof(char *),
			      "Allocating space for active file");

    while ((l = getaline(f))) {
	act = (char **)realloc(act, (acount + 1) * sizeof(char *));
	if (act == NULL) {
	    fprintf(stderr, "realloc returned NULL\n");
	    exit(1);
	}
	act[acount] = strdup(l);
	acount++;
    }
    fclose(f);

    qsort(act, acount, sizeof(char *), &comp);

    for (i = 0; i < acount; i++)
	printf("%s\n", act[i]);

    return 0;
}
