/*
libutil -- read filter file and do filtering of messages

Written by Cornelius Krasel <krasel@wpxx02.toxi.uni-wuerzburg.de>.
Copyright 1998.

See file COPYING for restrictions on the use of this software.
*/

#include "leafnode.h"
#include <sys/types.h>
#include <ctype.h>
#include <regex.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

struct filterlist * filter;

/*
 * read filters into memory. Filters are just plain regexp's
 */
void readfilter( char *filterfile ) {
    FILE * ff;
    char * l;
    struct filterlist * f, * oldf ;

    if ( filterfile == NULL || !strlen(filterfile) )
	return;
    filter = NULL;
    ff = fopen( filterfile, "r" );
    if ( !ff ) {
	syslog( LOG_ERR, "Unable to open filterfile %s: %m", filterfile );
	printf( "Unable to open filterfile %s\n", filterfile );
	return;
    }
    oldf = NULL;
    debug = 0;
    while ( ( l = getaline( ff ) ) != NULL ) {
	if ( *l == '#' || *l == '\0' )
	    continue ;
	f = (struct filterlist *)critmalloc( sizeof(struct filterlist),
					     "Allocating filterlist space" );
	f->expr = ( regex_t *) critmalloc( sizeof( regex_t ),
					   "Allocating filter space" );
	f->next = NULL;
	if ( regcomp( f->expr, l, REG_NOSUB | REG_NEWLINE ) ) {
	    syslog( LOG_ERR, "Invalid filter pattern %s", l );
	    printf( "Invalid filter pattern %s", l );
	    free( f );
	} else {
	    if ( !filter )
		filter = f;
	    else
		oldf->next = f;
	    oldf = f;
	}
    }
    debug = debugmode;
    fclose( ff );
}

/*
 * read and filter headers.
 * Return true if headers are correct, false otherwise
 */
int dofilter( char *h ) {
    struct filterlist * f ;
    int match ;

    f = filter;
    match = REG_NOMATCH ;
    while ( f && match == REG_NOMATCH ) {
	match = regexec( f->expr, h, 0, NULL, 0 );
	f = f->next ;
    }
    if ( match == 0 )
	return TRUE;
    else
	return FALSE;
}
