/***************************************************************************
                          main.c  -  description
                             -------------------
    begin                : Don Sep  6 12:02:57 CEST 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#include "lbreakout.h"
#include "file.h"
#include "chart.h"
#include "config.h"
#include "shrapnells.h"
#include "event.h"
#include "levels.h"
#include "game.h"
#ifdef SOUND
#include "audio.h"
#endif
#include "manager.h"
#include "editor.h"
#include "help.h"
#include "theme.h"

int term_game = 0;
extern Sdl sdl;
extern Config config;
extern char **levelset_home_names;
extern Font *font;
extern char **theme_names;

int main(int argc, char *argv[])
{
    int result = ACTION_NONE;
    int leave = 0;
    char *editor_file = 0;
    char path[512];

    /* lbreakout info */
    printf( "LBreakout2 %s\nCopyright 2001 Michael Speck\nPublished under GNU GPL\n---\n", VERSION );
    printf( "Looking up data in: %s\n", SRC_DIR );
    printf( "Looking up own levels in: %s/%s/lbreakout2-levels\n", (getenv( "HOME" )?getenv( "HOME" ):"."), CONFIG_DIR_NAME );
#ifndef SOUND
    printf( "Compiled without sound and music\n" );
#endif

    set_random_seed(); /* set random seed */

    config_load();

    init_sdl( SDL_INIT_VIDEO | SDL_INIT_AUDIO | SDL_INIT_TIMER );
    set_video_mode( std_video_mode( config.fullscreen ) );
    SDL_WM_SetCaption( "LBreakout2", 0 );
    sdl.fade = config.fade;
    SDL_SetEventFilter( event_filter );
#ifdef SOUND
    audio_open();
    sound_enable( config.sound );
    sound_volume( config.volume * 16 );
#endif

    /* load resources */
    /* for simplicity all functions are kept but anything
     * that is now themeable is loaded in
     * theme_load instead of the original function
     * (deleting resources works analouge)
     */
    theme_get_list();
    theme_load( theme_names[config.theme_id] );
    /* old functions still with initialzations of
     * lists or variables 
     */
    game_create();
    exp_load();
    editor_create();
    hint_load_res();
    manager_create();
    chart_load();
	help_create();
    /* run game */
    manager_fade( FADE_IN );
    while( !leave && !term_game ) {
        result = manager_run();
        switch( result ) {
            case ACTION_QUIT: leave = 1; break;
            case ACTION_PLAY:
                manager_fade( FADE_OUT );
                if ( game_init() ) game_run();
                game_clear();
                manager_fade( FADE_IN );
                break;
            case ACTION_EDIT:
                /* new set? */
                if ( strequal( "<CREATE SET>", levelset_home_names[config.levelset_home_id] ) ) {
                    editor_file = calloc( 16, sizeof( char ) );
                    sprintf( path, "%s/%s/lbreakout2-levels", getenv( "HOME" ), CONFIG_DIR_NAME );
                    if ( !enter_string( font, "Set Name:", editor_file, 12 ) || !file_check( path, editor_file, "w" ) ) {
                        free( editor_file );
                        break;
                    }
                    else
                        manager_update_set_list();
                }
                else
                    editor_file = strdup( levelset_home_names[config.levelset_home_id] );
                if ( editor_init( editor_file ) ) {
                    manager_fade( FADE_OUT );
                    editor_run();
                    editor_clear();
                    manager_fade( FADE_IN );
                }
                free( editor_file ); editor_file = 0;
                break;
			case ACTION_QUICK_HELP:
				help_run();
				break;
            default: break;
        }
    }
    manager_fade( FADE_OUT );
    /* delete stuff */
    help_delete();
	manager_delete();
	chart_save();
    chart_delete();
    editor_delete();
    exp_delete();
    game_delete();
    hint_delete_res();
    theme_delete();
    theme_delete_list();
    
#ifdef SOUND
    audio_close();
#endif
    config_save();

    return EXIT_SUCCESS;
}
