/***************************************************************************
                          config.c  -  description
                             -------------------
    begin                : Tue Feb 13 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <SDL.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "sdl.h"
#include "config.h"

#ifdef _WIN32
 #define MKDIR(d, p) mkdir(d)
#else
 #define MKDIR mkdir
#endif

Config config;

#define CONFIG_FILE_NAME "lbreakout2.conf"

/* check if config directory exists; if not create it and set config_dir */
void config_check_dir()
{
    char level_dir[512];
    sprintf( config.dir_name, "%s/%s", (getenv( "HOME" )?getenv( "HOME" ):"."), CONFIG_DIR_NAME );
    /* test and create .lgames */
    if ( opendir( config.dir_name ) == 0 ) {
        fprintf( stderr, "couldn't find/open config directory '%s'\n", config.dir_name );
        fprintf( stderr, "attempting to create it... " );
        MKDIR( config.dir_name, S_IRWXU );
        if ( opendir( config.dir_name ) == 0 )
            fprintf( stderr, "failed\n" );
        else
            fprintf( stderr, "ok\n" );
    }
    /* create levels directory */
    sprintf( level_dir, "%s/lbreakout2-levels", config.dir_name );
    MKDIR( level_dir, S_IRWXU );
    /* create themes directory */
    sprintf( level_dir, "%s/lbreakout2-themes", config.dir_name );
    MKDIR( level_dir, S_IRWXU );
}

/* set config to default */
void config_reset()
{
    /* levels */
    config.levelset_id = 0;
    config.levelset_count = 0;
    config.levelset_home_id = 0;
    config.levelset_home_count = 0;
    /* player */
    config.player_count = 1;
    strcpy( config.player_names[0], "Michael" );
    strcpy( config.player_names[1], "Mr.X" );
    strcpy( config.player_names[2], "Mr.Y" );
    strcpy( config.player_names[3], "Mr.Z" );
    /* game */
    config.diff = 1;
    config.startlevel = 0;
    /* controls */
    config.k_left = SDLK_LEFT;
    config.k_right = SDLK_RIGHT;
    config.k_fire = SDLK_SPACE;
    config.k_return = SDLK_BACKSPACE;
    config.control = 2;
    config.grab = 0;
    config.rel_motion = 0;
    config.motion_mod = 100;
    config.convex = 1;
    config.invert = 0;
    config.i_key_speed = 50;
    config.key_speed = 0.5;
    /* sounds */
    config.sound = 1;
    config.volume = 8;
    config.speech = 1;
    /* graphics */
    config.trp = 1;
    config.anim = 2;
    config.fullscreen = 0;
    config.fade = 1;
    config.shadow = 1;
    config.fps = 0;
	config.ball_level = BALL_BELOW_BONUS;
    /* various */
    config.use_hints = 1;
    config.return_on_click = 0;
    config.theme_id = 0;
    config.theme_count = 1;
}

/* load config */
void config_load( )
{
    FILE *file = 0;
    char file_name[512];
    struct stat dir_stat;
    char dir_name[512];

    /* check if directory exists, if not create it */
    config_check_dir();

    sprintf( file_name, "%s/%s", config.dir_name, CONFIG_FILE_NAME );
    if ( ( file = fopen( file_name, "r" ) ) == 0 ) {
        /* not found? use defaults! */
        fprintf( stderr, "config file '%s' not found... using defaults\n", file_name );
        config_reset();
    }
    else {
        /* check if file size fits struct size; if not use defaults */
        stat( file_name, &dir_stat );
        if ( dir_stat.st_size != sizeof( Config ) ) {
            fprintf( stderr, "config file '%s' corrupted... using defaults\n", file_name );
            config_reset();
        }
        else {
            /* must backup dir_name! */
            strcpy( dir_name, config.dir_name );
            /* read it from file */
            fread( &config, sizeof( Config ), 1, file );
            strcpy( config.dir_name, dir_name );
        }
        fclose( file );
    }
}

/* save config */
void config_save( )
{
    FILE *file = 0;
    char file_name[512];

    sprintf( file_name, "%s/%s", config.dir_name, CONFIG_FILE_NAME );
    if ( ( file = fopen( file_name, "w" ) ) == 0 )
        fprintf( stderr, "cannot access config file '%s' to save settings\n", file_name );
    else {
        fwrite( &config, sizeof( Config ), 1, file );
        fclose( file );
    }
}

