/* 
    This is the little summery of the players achievements in a level

    Copyright, 2003 Caleb Moore
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "text.h"
#include "graphics.h"
#include "game.h"
#include <SDL/SDL.h>
#include <sstream>
using namespace std;

static unsigned int font;
static unsigned int background;
static bool assigned;

extern int clearnessneeded;
extern int clearness;
extern int currentlevel;
extern int lives;
extern int score;

void display_scorescreen()
{
  if (assigned == 0)
    {
      assigned = 1;
      background = load_bmp("lava.jpg");
      font = load_font("font.bmp");
    }

  display_bmp(background, 1, 1);
  
  char n [200];
  snprintf(n, 200, "Level: %i", currentlevel);
  print_text(n, font, 200, 10);
  snprintf(n, 200, "Lives: %i", lives);
  print_text(n, font, 200, 30);
  snprintf(n, 200, "Clearness: %i Needed: %i", clearness, clearnessneeded);
  print_text(n, font, 200, 50);

  int isol = isolation() * 100;
  int overachiever = (clearness - clearnessneeded) * 100;
  int levelbonus = currentlevel * 300;
  score = score + isol + overachiever + levelbonus;

  snprintf(n, 200, "Isolation: %i", isol);
  print_text(n, font, 200, 90);
  snprintf(n, 200, "Over Achiver: %i", overachiever);
  print_text(n, font, 200, 110);
  snprintf(n, 200, "Level Bonus: %i", levelbonus);
  print_text(n, font, 200, 130);

  snprintf(n, 200, "Score: %i", score);
  print_text(n, font, 200, 170);
  refresh_screen();

  SDL_Event event;
  while (1)
    {
      while(SDL_PollEvent(&event))
	{
	  if (event.type == SDL_MOUSEBUTTONDOWN ||
	      event.type == SDL_KEYDOWN) 
	    {
	      return;
	    }
	  
	  if (event.type == SDL_QUIT) 
	    {
	      exit(0);
	    }
	}
    }
}
