/* Copyright (c) 1994-1996 David Hogan, see README for licence details */
#include <stdio.h>
#include <stdlib.h>
#include <sys/wait.h>

#include <X11/X.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>

#include "dat.h"
#include "fns.h"

Client	*hiddenc[MAXHIDDEN];

int	numhidden = 0;

char	*hiddenitems[MAXHIDDEN + 1] =
{
	0,
};

char	*mainitems[] =
{
	"New",
	"Reshape",
	"Move",
	"Delete",
	"Hide",
	"-------------- Desktop --",
	"clickthru on/off",
	"tile_resize on/off",
	"skip_focus on/off",
	"--------------- Window --",
	"is_float on/off",
	"is_tool on/off",
	"is_sticky on/off",
	"is_notile on/off",
	"show_class on/off",
	"--------------- larswm --",
	"Restart",
	"--------------- LOGOUT --",
	"E X I T",
	0,
};

Menu	hiddenmenu =
{
	hiddenitems,
};

Menu	mainmenu =
{
	mainitems,
};


void button(XButtonEvent *e)
{
	int n, shift;
	Client *c;
	Window dw;
	ScreenInfo *s;

	s = getscreen(e->root);

	if (s == 0)
		return;

	if (e->window == s->barwin)
	{
		if (current && current->screen == s)
			cmapnofocus(s);

		switch (e->button)
		{
		case Button1:
			prev_desktop (s);
			break;
		case Button2:
			toggle_notile (s);
			break;
		case Button3:
			next_desktop (s);
			break;
		case Button4:
			prev_desktop (s);
			break;
		case Button5:
			next_desktop (s);
			break;
		}

		if (current && current->screen == s)
			cmapfocus(current);

		return;
	}

	c = getclient(e->window, 0);

	if (c)
	{
		e->x += c->x - BORDER;
		e->y += c->y - BORDER;
	}
	else if (e->window != e->root)
	{
		XTranslateCoordinates(dpy, e->window, s->root, e->x, e->y, &e->x, &e->y, &dw);
	}

	if (current && current->screen == s)
		cmapnofocus(s);

	switch (e->button)
	{
	case Button1:
		if (c)
		{
			int skip;
			int wasleft = c->isleft;
			int ntraised = s->notile_raised[s->desktop];
			int force = (e->state & ShiftMask) == ShiftMask;
			int ctrl = (e->state & ControlMask) == ControlMask;

			if (!c->isnotile && s->skip_focus[s->desktop] && s->tile_resize[s->desktop])
				skip = !ctrl;
			else
				skip = ctrl;

			if (!ctrl && c->isnotile != s->notile_raised[s->desktop])
				toggle_notile (s);

			if (!skip)
			{
				raise_tbar (c->screen);
				XMapRaised(dpy, c->parent);
				top(c);
			}

			if (c->input || force)
				active (c);

			if (!skip && !c->isnotile)
				tile_all (s);

                        if ((skip || wasleft || c->isnotile) && c->input && !force && !ctrl &&
					s->clickthru[s->desktop] && (c->istool || c->isfloat || (c->isnotile == ntraised)))
				XAllowEvents (dpy, ReplayPointer, e->time);
		}
		break;

	case Button2:
		if (c)
		{
			if (s->clickthru[s->desktop] && c->input &&
					(c->istool || c->isfloat || (c->isnotile == s->notile_raised[s->desktop])))
			{
				XAllowEvents (dpy, ReplayPointer, e->time);
			}
		}
		break;

	case Button3:
		if (c && s->clickthru[s->desktop] && c->input && c->isnotile &&
				(c->istool || c->isfloat || s->notile_raised[s->desktop]))
		{
			XAllowEvents (dpy, ReplayPointer, e->time);
		}
		else if ((e->state & ShiftMask) == ShiftMask)
		{
			if (numhidden > 0)
			{
				switch (n = menuhit(e, &hiddenmenu))
	       			{
				case -1:
					break;
				default:
					unhide(n, 1);
					break;
				}
			}
		}
		else switch (n = menuhit(e, &mainmenu))
	       	{
		case 0:
			spawn(s, 0);
			break;
		case 1:
			reshape(selectwin(1, 0, s));
			break;
		case 2:
			move(selectwin(0, 0, s));
			break;
		case 3:
			shift = 0;
			c = selectwin(1, &shift, s);
			wmdelete(c, shift);
			break;
		case 4:
			hide(selectwin(1, 0, s));
			break;
			/* desktop */
		case 6:
			toggle_clickthru (s);
			break;
		case 7:
			toggle_tile_resize (s);
			break;
		case 8:
			toggle_skip_focus (s);
			break;
			/* window */
		case 10:
			toggle_isfloat (selectwin (1, 0, s));
			break;
		case 11:
			toggle_istool (selectwin (1, 0, s));
			break;
		case 12:
			toggle_issticky (selectwin (1, 0, s));
			break;
		case 13:
			toggle_isnotile (selectwin (1, 0, s));
			break;
		case 14:
			toggle_show_class();
			break;
			/* larswm */
		case 16:
			cleanup ();
			execvp (myargv[0], myargv);
			fatal ("execvp");
			break;
			/* logout */
		case 18:
			cleanup ();
			exit (0);
			break;
		}
		break;

	case Button4:
		prev_desktop(s);
		break;

	case Button5:
		next_desktop(s);
		break;
	}

	if (current && current->screen == s)
		cmapfocus(current);
}

void spawn(ScreenInfo *s, char *p)
{
	/*
	 * ugly dance to avoid leaving zombies.  Could use SIGCHLD,
	 * but it's not very portable.
	 */
	if (fork() == 0)
	{
		if (fork() == 0)
		{
			close(ConnectionNumber(dpy));

			if (s->display[0] != '\0')
			{
				putenv(s->display);
			}

			if (p)
			{
				execl(shell, shell, "-c", p, 0);
				fprintf(stderr, "larswm: execl %s", shell);
				perror(" failed");
			}
			else if (prefs.termprog)
			{
				execl(shell, shell, "-c", prefs.termprog, 0);
				fprintf(stderr, "larswm: execl %s", shell);
				perror(" failed");
			}
			else
			{
				execlp("xterm", "xterm", 0);
				fatal ("execlp xterm");
			}
		}

		exit(0);
	}

	wait((int *) 0);
}

void reshape(Client *c)
{
	int odx, ody;

	if (c == 0)
		return;
	odx = c->dx;
	ody = c->dy;
	if (sweep(c) == 0)
		return;
	if (c->input)
		active(c);
	top(c);
	raise_tbar (c->screen);
	XMapRaised(dpy, c->parent);
	XMoveResizeWindow(dpy, c->parent, c->x-BORDER, c->y-BORDER,
					c->dx+2*BORDER, c->dy+2*BORDER);
	if (c->dx == odx && c->dy == ody)
		sendconfig(c);
	else
		XMoveResizeWindow(dpy, c->window, BORDER, BORDER, c->dx, c->dy);
}

void move(Client *c)
{
	if (c == 0)
		return;
	if (drag(c) == 0)
		return;
	if (c->input)
		active(c);
	top(c);
	raise_tbar (c->screen);
	XMapRaised(dpy, c->parent);
	XMoveWindow(dpy, c->parent, c->x-BORDER, c->y-BORDER);
	sendconfig(c);
}

void wmdelete(Client *c, int shift)
{
	if (c == 0)
		return;
	if ((c->proto & Pdelete) && !shift)
		sendcmessage(c->window, wm_protocols, wm_delete, 0);
	else
		XKillClient(dpy, c->window);		/* let event clean up */
}

void hide(Client *c)
{
	if (c == 0 || numhidden == MAXHIDDEN)
		return;
	if (hidden(c)) {
		return;
	}
	XUnmapWindow(dpy, c->parent);
	XUnmapWindow(dpy, c->window);
	wmsetstate(c, IconicState);
	if (c == current)
		revert_window(c->screen);
	hiddenc[numhidden] = c;

	if (c->iconname)
	{
		hiddenitems[numhidden] = c->iconname;
	}
	else
	{
		hiddenitems[numhidden] = c->label;
	}

	numhidden++;
	hiddenitems[numhidden] = 0;

	c->hidden = 1;

	update_tbar ();
}

void unhide(int n, int map)
{
	Client *c;
	int i;

	if (n >= numhidden)
	{
		return;
	}

	c = hiddenc[n];

	if (!hidden(c))
	{
		return;
	}

	if (map)
	{
		c->desktop = c->screen->desktop;
		raise_tbar (c->screen);
		XMapWindow(dpy, c->window);
		XMapRaised(dpy, c->parent);
		wmsetstate(c, NormalState);
		top(c);

		if (c->input)
			active(c);
		else
			raise_tbar (c->screen);
	}

	numhidden--;

	for (i = n; i < numhidden; i ++)
	{
		hiddenc[i] = hiddenc[i+1];
		hiddenitems[i] = hiddenitems[i+1];
	}

	hiddenitems[numhidden] = 0;
	c->hidden = 0;

	update_tbar ();
}

void unhidec(Client *c, int map)
{
	int i;

	if (!c->hidden)
		return;

	for (i = 0; i < numhidden; i++)
		if (c == hiddenc[i]) {
			unhide(i, map);
			return;
		}
}

void renamec(Client *c, char *name)
{
	int i;

	if (name == 0)
		name = "???";
	c->label = name;
	if (!hidden(c))
		return;
	for (i = 0; i < numhidden; i++)
		if (c == hiddenc[i]) {
			hiddenitems[i] = name;
			return;
		}
}
