.TH larswm 1
.SH NAME
larswm \- Tiling Window Manager for X
.SH SYNOPSIS
.B larswm
[
.B \-display
.I dpy
] [
.B \-f
.I file
] [
.B \-p
.I file
] [
.B \-defaults
] [
.B \-v
]
.B larswm
[
.BR message | flushmessage | exit | restart
]
.SH DESCRIPTION
.I larswm
is a small window manager for X.  What makes it unique compared to most window managers is its automatic window tiling.
.SH OPTIONS
The following command line options are supported:
.TP 18
.BI \-display " dpy"
lets you specify which display you want
.I larswm
to manage.
.TP 18
.BI \-f " file"
lets you specify a preferences file other than $HOME/.larswmrc to use for configuration.
.TP 18
.BI \-p " file"
lets you specify a named pipe other than $HOME/.larswmfifo to use for status bar messages.
.TP 18
.B \-defaults
prints to standard out a complete resource file for
.I larswm
containing all options and their defaults.
.TP 18
.B \-v
prints the current version on standard error, then exits.
.TP 18
.B message
tells the running
.I larswm
to check the named pipe for data to be displayed on the status bar.
.TP 18
.B flushmessage
tells the running
.I larswm
to read and throw away everything currently in the named pipe. Can be used before writing to the pipe to ensure there is no
old, unread data there that would be displayed before the message you want to show.
.TP 18
.B exit
tells the running
.I larswm
to exit gracefully.  This is the normal way to log out if your session hangs on the window manager.
.TP 18
.B restart
tells the running
.I larswm
to restart.  Use this if you have updated your preferences file and want the new preferences to take effect without first logging out.
.SH FILES
.TP 18
.B $HOME/.larswmrc
this is the default preferences file that is read when
.I larswm
starts up.
.TP 18
.B $HOME/.larswmfifo
this is the default named pipe that if it exists,
.I larswm
will read up to 132 characters from it every second and display them on the status bar.
.SH NOTES
For a complete manual, please go to the
.I larswm
home page at
.I http://www.fnurt.net/larswm
and download the full manual in PDF, PS or HTML format.
.SH AUTHORS
.I larswm
was created by Lars Bernhardsson <lab@fnurt.net> by building on
.I 9wm
by David Hogan.
