/* Copyright (c) 2000 Lars Bernhardsson, see README for licence details */
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#include <X11/X.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>

#include "dat.h"
#include "fns.h"

static char cmd_output[BAR_OUTPUT_SIZE + 1];
static char *cmd_output_ptr = 0;
static int show_class = 0;


void toggle_show_class (void)
{
	show_class = !show_class;
	update_tbar ();
}

void flush_cmd_output (void)
{
	char buf[1024];

	while (read (cmd_pipe, buf, sizeof (buf)) > 0);
}

void update_cmd_output (void)
{
	int bytes;

	if (cmd_pipe == -1)
		return;

	if ((bytes = read (cmd_pipe, cmd_output, BAR_OUTPUT_SIZE)) > 0)
	{
		cmd_output[bytes] = '\0';
		cmd_output_ptr = cmd_output;
	}
	else
	{
		cmd_output_ptr = 0;
	}

	update_tbar ();
	XSync (dpy, False);
}

void draw_tbar (ScreenInfo *s)
{
	int tlen, plen;
	char sbar[256], tmp[128];

	if (!s || !prefs.bar)
		return;

	XClearWindow(dpy, s->barwin);

	if (current && current->label && (current->screen == s))
	{
		tlen = strlen (current->label);

		if (tlen > 0)
		{
			plen = XTextWidth (font, current->label, tlen);
			XDrawString (dpy, s->barwin, s->gc, BAR_HEIGHT, BAR_TEXT_Y, current->label, tlen);
		}
	}

	sbar[0] = '\0';

	if (show_class && current && (current->screen == s))
	{
		strcat (sbar, "(");

		if (current->class)
			strcat (sbar, current->class);

		strcat (sbar, "~");

		if (current->instance)
			strcat (sbar, current->instance);

		strcat (sbar, ")  ");
	}

	strcat (sbar, prefs.dtname[s->num][s->desktop]);
	strcat (sbar, "  ");

	tmp[0] = '[';
	tmp[1] = s->notile_raised[s->desktop] ? '-' : 'T';
	tmp[2] = s->clickthru[s->desktop] ? 'C' : '-';
	tmp[3] = s->tile_resize[s->desktop] ? 'R' : '-';
	tmp[4] = s->skip_focus[s->desktop] ? 'S' : '-';
	tmp[5] = numhidden ? 'H' : '-';
	tmp[6] = ']';
	tmp[7] = '\0';

	strcat (sbar, tmp);

	if (cmd_output_ptr)
	{
		strcat (sbar, "  ");
		strcat (sbar, cmd_output);
	}

	tlen = strlen (sbar);
	plen = XTextWidth (font, sbar, tlen);

	if (tlen > 0)
	{
		XDrawString (dpy, s->barwin, s->gc, BAR_WIDTH(s) - plen - BAR_HEIGHT, BAR_TEXT_Y, sbar, tlen);
	}
}

void update_tbar (void)
{
	int i;

	if (!prefs.bar)
		return;

	for (i = 0; i < num_screens; i++)
		draw_tbar (&screens[i]);
}

void raise_tbar (ScreenInfo *s)
{
	Client *c;

	if (!s)
		return;

	for (c = clients; c; c = c->next)
		if (c->isfloat && normal (c) &&
				(c->screen == s) &&
				(c->issticky ||
				 (c->desktop == c->screen->desktop)))
			XMapRaised (dpy, c->parent);

	if (!prefs.bar)
		return;

	XMapRaised (dpy, s->barwin);
}

ScreenInfo *getbarscreen (Window w)
{
	int i;

	if (!prefs.bar)
		return 0;

	for (i = 0; i < num_screens; i++)
	{
		if (screens[i].barwin == w)
			return &screens[i];
	}

	return 0;
}
