/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *
 *	$Id: rpi_tcp.h,v 6.1.2.1 2002/10/09 19:49:00 brbarret Exp $
 *
 *	Function:	- TCP client-to-client interface header
 */

#ifndef _RPI_TCP_H
#define _RPI_TCP_H

#include <all_hash.h>
#include <all_list.h>
#include <mpisys.h>
#include <portable.h>
#include <t_types.h>

/*
 * constants
 */
#define INITHASH	((int4) 59)		/* initial hash table size */

/*
 * structures
 *
 * client-to-client specific process data
 */
#if LAM_RPI_TCP   /* If its shmem, then we don't want this */
struct c2c_proc {
	struct c2c_envl	cp_env;			/* incoming envelope */
	int		cp_sock;		/* socket descriptor */
	int		cp_nenvin;		/* # env. bytes left to read */
	char		*cp_envbuf;		/* envelope buffer pointer */
	int		cp_nmsgin;		/* # msg. bytes left to read */
	char		*cp_msgbuf;		/* message buffer pointer */
	int		cp_extra;		/* # bytes to go into sink */
	MPI_Request	cp_wreq;		/* req writing to process */
	MPI_Request	cp_rreq;		/* reading req */
	MPI_Request	cp_mreq;		/* req to match from */
	int		(*cp_readfn)();		/* read function */
	struct cbuf_msg *cp_bmsg;		/* buffering? */
	int		cp_nbfde;		/* # buffered envelopes */
};
#endif
/*
 * public functions
 */ 
int			_rpi_c2c_init(void);
int			_rpi_c2c_addprocs(void);
int			_rpi_c2c_build(MPI_Request);
int			_rpi_c2c_start(MPI_Request, MPI_Request);
int			_rpi_c2c_destroy(MPI_Request);
int			_rpi_c2c_advance(MPI_Request, int);
int			_rpi_c2c_iprobe(MPI_Request);
int			_rpi_c2c_finalize(struct _proc*);
int			_c2c_envl_cmp(struct c2c_envl *pe,
				      struct c2c_envl *pq);
int			_c2c_comm_dead(MPI_Request);
void			_c2c_fill_mpi_status(MPI_Request req,
					     int rank,
					     int tag,
					     int length);
void			_c2c_fill_wildcards(MPI_Request,
					    struct c2c_envl*);

/*
 * global variables
 */
extern int			_c2c_flblock;		/* blocking flag */
extern int			_c2c_haveadv;		/* have advanced? */


#endif	/* _RPI_TCP_H */
