/* 
 *   $Id: status_setb.c,v 1.5 2001/01/23 13:56:57 jsquyres Exp $    
 *
 *   Copyright (C) 1997 University of Chicago. 
 *   See COPYRIGHT notice in top-level directory.
 */

#include "mpi.h"

#ifdef MPICH

int MPIR_Status_set_bytes(MPI_Status *status, MPI_Datatype datatype, 
			  int nbytes)
{
  status->count = nbytes;
  return MPI_SUCCESS;
}

#elif LAM_MPI

/* Added LAM version by JMS on 20 Jan 2001 */

int MPIR_Status_set_bytes(MPI_Status *status, MPI_Datatype datatype, 
			  int nbytes)
{
  /* Bogusness to silence compiler warnings */

  if (datatype == MPI_DATATYPE_NULL);

  status->st_length = nbytes;
  return MPI_SUCCESS;
}

#endif
