// $Id: iprobe.cc,v 1.1.1.1.2.1 2001/10/29 04:32:57 bbarrett Exp $
//
// Copyright 1997-2001, University of Notre Dame.
// Authors: Jeffrey M. Squyres, Jeremy G. Siek, Michael P. McNally, and
//          Andrew Lumsdaine
// 
// This file is part of the Notre Dame C++ bindings for MPI.
// 
// You should have received a copy of the License Agreement for the Notre
// Dame C++ bindings for MPI along with the software; see the file
// LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN 46556.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted subject to the conditions specified in the
// LICENSE file.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
// IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
// 
// Additional copyrights may follow.
/****************************************************************************

 MESSAGE PASSING INTERFACE TEST CASE SUITE

 Copyright IBM Corp. 1995

 IBM Corp. hereby grants a non-exclusive license to use, copy, modify, and
 distribute this software for any purpose and without fee provided that the
 above copyright notice and the following paragraphs appear in all copies.

 IBM Corp. makes no representation that the test cases comprising this
 suite are correct or are an accurate representation of any standard.

 In no event shall IBM be liable to any party for direct, indirect, special
 incidental, or consequential damage arising out of the use of this software
 even if IBM Corp. has been advised of the possibility of such damage.

 IBM CORP. SPECIFICALLY DISCLAIMS ANY WARRANTIES INCLUDING, BUT NOT LIMITED
 TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS AND IBM
 CORP. HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.

****************************************************************************

 These test cases reflect an interpretation of the MPI Standard.  They are
 are, in most cases, unit tests of specific MPI behaviors.  If a user of any
 test case from this set believes that the MPI Standard requires behavior
 different than that implied by the test case we would appreciate feedback.

 Comments may be sent to:
    Richard Treumann
    treumann@kgn.ibm.com

****************************************************************************
*/
#include "mpi2c++_test.h"

void
iprobe()
{
  char msg[150];
  int cnt;
  int data;
  int flag;
  int tag;
  int src;
  MPI::Intracomm comm;
  MPI::Status status;

  comm = MPI::COMM_WORLD;

  Testing("Iprobe w/ Status");
  
  if((my_rank % 2) == 0) {
    data = 7;
    comm.Send(&data, 1, MPI::INT, my_rank + 1, 1);
  } else if((my_rank % 2) == 1)  {
    data = -1;

    for(;;) {
      flag = comm.Iprobe(my_rank - 1, 1, status);
      if(flag) 
	break;
    }

    src = status.Get_source();
    if(src != my_rank - 1) {
      sprintf(msg, "NODE %d - 1) ERROR in MPI::Iprobe, source = %d, should be %d",
	      my_rank, src, my_rank - 1);
      Fail(msg);
    }

    tag = status.Get_tag();
    if(tag != 1) {
      sprintf(msg, "NODE %d - 2) ERROR in MPI::Iprobe, tag = %d, should be 1",
	      my_rank, tag);
      Fail(msg);
    }

    cnt = status.Get_count(MPI::INT);
    if(cnt != 1) {
      sprintf(msg, "NODE %d - 3) ERROR in MPI::Iprobe, count = %d, should be 1",
	      my_rank, tag);
      Fail(msg);
    }

    comm.Recv(&data, cnt, MPI::INT, src, tag, status);
    if(data != 7) {
      sprintf(msg, "NODE %d - 4) ERROR in MPI::Recv, data = %d, should be 7",
	      my_rank, tag);
      Fail(msg);
    }
  }
  
  Pass(); // Iprobe w/ Status
  
  comm.Barrier();
  
  Testing("Iprobe w/o Status");
  
  if((my_rank % 2) == 0) {
    data = 7;
    comm.Send(&data, 1, MPI::INT, my_rank + 1, 1);
  } else if((my_rank % 2) == 1) {
    data = -1;

    for(;;)  {
      flag = comm.Iprobe(my_rank - 1, 1);
      if(flag) 
	break;
    }

    comm.Recv(&data, 1, MPI::INT, my_rank - 1, 1);
    if(data != 7) {
      sprintf(msg, "NODE %d - 5) ERROR in MPI::Recv, data = %d, should be 7",
	      my_rank, tag);
      Fail(msg);
    }
  }
  
  Pass(); // Iprobe w/o Status

  if(comm != MPI::COMM_NULL && comm != MPI::COMM_WORLD)
    comm.Free();
}

