dnl -*- shell-script -*-
dnl
dnl Copyright (c) 2001-2002 The Trustees of Indiana University.  
dnl                         All rights reserved.
dnl Copyright (c) 1998-2001 University of Notre Dame. 
dnl                         All rights reserved.
dnl Copyright (c) 1994-1998 The Ohio State University.  
dnl                         All rights reserved.
dnl 
dnl This file is part of the LAM/MPI software package.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl LAM/MPI source distribution.
dnl
dnl $Id: cxx_find_exception_flags.m4,v 1.2.2.2 2002/10/09 19:48:23 brbarret Exp $
dnl

define([LSC_CXX_FIND_EXCEPTION_FLAGS],[
#
# Arguments: prefix (optional)
#
# Dependencies: none
#
# Get the exception handling flags for the C++ compiler.  Leaves
# CXXFLAGS undisturbed.
# Provides --with-exflags command line argument for configure as well.
#
# Sets prefix_CXX_EXCEPTION_CXXFLAGS and prefix_CXX_EXCEPTION_LDFLAGS as
# appropriate.
# Must call AC_SUBST manually
#

# Figure out what prefix to use
lsc_mpi_prefix="$1"
if test "$lsc_mpi_prefix" = ""; then
    lsc_mpi_prefix="LSC"
fi

# Command line flags
AC_ARG_WITH(exflags,   [  --with-exflags          Specify flags necessary to enable exceptions], lsc_force_exflags="$withval")

lsc_CXXFLAGS_SAVE="$CXXFLAGS"
AC_MSG_CHECKING([for compiler exception flags])
if test "$lsc_force_exflags" != ""; then
    lsc_exflags="$lsc_force_exflags"
elif test "$GXX" = "yes"; then
    CXXFLAGS="$CXXFLAGS -fexceptions"

    AC_LANG_SAVE
    AC_LANG_CPLUSPLUS
    AC_TRY_COMPILE(, [try { int i = 0; } catch(...) { int j = 2; }], lsc_happy=1, lsc_happy=0)

    if test "$lsc_happy" = "1"; then
	lsc_exflags="-fexceptions";
    else
	CXXFLAGS="$CXXFLAGS_SAVE -fhandle-exceptions"
	AC_TRY_COMPILE(, [try { int i = 0; } catch(...) { int j = 2; }], lsc_happy=1, lsc_happy=0)
	if test "$lsc_happy" = "1"; then
	    lsc_exflags="-fhandle-exceptions";
	fi
    fi
    AC_LANG_RESTORE
elif test "`basename $CXX`" = "KCC" -o "`basename $LAMHCP`" = "KCC"; then
    lsc_exflags="--exceptions"
fi
CXXFLAGS="$lsc_CXXFLAGS_SAVE"

# Save the result
lsc_name="${lsc_prefix}_CXX_EXCEPTION_CXXFLAGS"
lsc_str=${lsc_name}=\"$lsc_exflags\""
eval $lsc_str
lsc_name="${lsc_prefix}_CXX_EXCEPTION_LDFLAGS"
lsc_str=${lsc_name}=\"$lsc_exflags\""
eval $lsc_str
if test "$lsc_exflags" = ""; then
    AC_MSG_RESULT([none necessary])
else
    AC_MSG_RESULT([$lsc_exflags])
fi

# Clean up
unset lsc_prefix lsc_force_exflags lsc_CXXFLAGS_SAVE lsc_exflags lsc_happy \
    lsc_name lsc_str])dnl

