/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: laminited.c,v 6.5.2.1 2002/10/09 19:49:10 brbarret Exp $
 *
 *	Function:	- test if MPI has been initialized/finalized
 */

#include <stdio.h>
#include <unistd.h>
#include <netdb.h>
#include <args.h>
#include <sys/param.h>

#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 * Local variables
 */
static char host[MAXHOSTNAMELEN];
static char pid[32];

/*
 * global variables
 */
int 			lam_flinit = 0;
int 			lam_flfinal = 0;

/*
 *	lam_inited
 *
 *	Function:	- check if MPI has been initialized
 *	Returns:	- TRUE or FALSE
 */
int
lam_inited()

{
/*
 * Using _kio_ki_pid works when a process is forked.
 *
 * return(_kio.ki_pid == getpid());
 */
  return(lam_flinit);
}

/*
 *	lam_finalized
 *
 *	Function:	- check if MPI has been finalized
 *	Returns:	- TRUE or FALSE
 */
int
lam_finalized()

{
  return(lam_flfinal);
}

/*
 *	lam_initerr
 *
 *	Function:	- if MPI not initialized, abort as an error
 */
void
lam_initerr()

{
  /* If we get an error here, it's no use calling kexit() because we
     will either not be attached to the local lamd yet, or we will
     have already detached.  Hence, calling kexit() to register the
     return status is useless.  :-( */

  if (lam_flinit == 0 && lam_flfinal == 0) {
    gethostname(host, MAXHOSTNAMELEN);
    LAMSetLastError(EMPINOINIT);
    snprintf(pid, 32, "%d", getpid());
    show_help("ALL", "uninitialized", host, pid, NULL);
    exit(LAM_EEXIT);
  } else if (lam_flfinal == 1) {
    char *rank = getenv("LAMRANK");
    if (rank == NULL)
      rank = "(unknown)";

    gethostname(host, MAXHOSTNAMELEN);
    LAMSetLastError(EMPIALREADYFINALIZE);
    snprintf(pid, 32, "%d", getpid());
    show_help("ALL", "already-finalized", host, pid, rank, NULL);
    exit(LAM_EEXIT);
  }
}
