/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: inited.c,v 6.3.2.1 2002/10/09 19:49:09 brbarret Exp $
 *
 *	Function:	- check if MPI has been initialized
 *	Accepts:	- result flag (out)
 *	Returns:	- MPI_SUCCESS
 */

#include <mpi.h>
#include <mpisys.h>

/*@
   MPI_Initialized - Indicates whether 'MPI_Init' has been called.

Output Parameter:

. flag - Flag is true (1) if 'MPI_Init' has been called and false (0)
otherwise.

Notes:

This function always returns 'MPI_SUCCESS'.

.N fortran

.N ACK
@*/
int MPI_Initialized(int *flag)
{
	if (flag) {
		*flag = lam_inited();
	}

	return(MPI_SUCCESS);
}
