/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *
 *	$Id: lamthreads.h,v 6.1.2.1 2002/10/09 19:48:59 brbarret Exp $
 *
 *	Function:	- header for LAM thread interface
 */

#ifndef _MPI_LAM_THREADS_H
#define _MPI_LAM_THREADS_H

#include <lam_config.h>


/*
 * types
 */
typedef struct {
  lam_real_mutex_t mutex;
  lam_thread_t thread;
} lam_mutex_t;

/*
 * Main LAM thread globals
 */
extern int		lam_thread_level;
extern lam_thread_t	lam_main_thread;
extern lam_mutex_t	lam_mpi_mutex;
extern lam_mutex_t	lam_updown_mutex;


/*
 * LAM thread interface
 */
void		lam_thread_init(int requested, int *pprovided);
lam_thread_t	lam_thread_self(void);
int		lam_thread_compare(lam_thread_t a, lam_thread_t b);
void		lam_thread_finalize(void);

/*
 * LAM mutex interface
 */
void		lam_mutex_init(lam_mutex_t *mutex);
void		lam_mutex_lock(lam_mutex_t *mutex);
int		lam_mutex_is_owner(lam_mutex_t *mutex);
void		lam_mutex_unlock(lam_mutex_t *mutex);
void		lam_mutex_finalize(lam_mutex_t *mutex);


#endif	/* _MPI_LAM_THREADS_H */
