/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB
 *
 *	$Log: rtrfget.c,v $
 *	Revision 6.2  1999/05/26 21:50:02  kmeyer1
 *	
 *	added copyright
 *	
 *	Revision 6.1  1996/11/24 00:26:16  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  14:05:08  gdburns
 * Ohio Release
 * 
 *	Function:	- unloads trace data from remote trace daemon
 */

#include <stdlib.h>
#include <unistd.h>

#include <events.h>
#include <ksignal.h>
#include <net.h>
#include <trreq.h>
#include <typical.h>

/*
 * external variables
 */
extern int		errno;

/*
 * local functions
 */
static int4		rtr();

/*
 *	lam_rtrfget
 *
 *	Function:	- reads trace data from remote node
 *	Accepts:	- target node ID
 *			- list number
 *			- process ID
 *			- file descriptor
 *	Returns:	- total length of received trace data
 */
int4
lam_rtrfget(nodeid, lnum, pid, fd)

int4			nodeid;
int4			lnum;
int4			pid;
int			fd;

{
	return(rtr(nodeid, lnum, pid, fd, TRQGET));
}

/*
 *	lam_rtrfforget
 *
 *	Function:	- destructively reads trace data from remote node
 *	Accepts:	- target node ID
 *			- list number
 *			- process ID
 *			- file descriptor
 *	Returns:	- total length of received trace data
 */
int4
lam_rtrfforget(nodeid, lnum, pid, fd)

int4			nodeid;
int4			lnum;
int4			pid;
int			fd;

{
	return(rtr(nodeid, lnum, pid, fd, TRQFORGET));
}

/*
 *	rtr
 *
 *	Function:	- unloads trace data from remote node
 *			- writes trace data into file
 *	Accepts:	- target node ID
 *			- list number
 *			- process ID
 *			- file descriptor
 *			- traced request code
 *	Returns:	- total length of received trace data
 */
static int4
rtr(nodeid, lnum, pid, fd, req)

int4			nodeid;
int4			lnum;
int4			pid;
int4			req;
int			fd;

{
	struct nmsg	nhead;		/* network message desc. */
	struct trreq  	*request;	/* traced request */
	struct trreply	*reply;		/* traced reply */
	int4		trtotal;	/* total matching traces */
	int4		trleft;		/* traces left to receive */
	int4		mask;		/* favourite index */

	request = (struct trreq *) nhead.nh_data;
	reply = (struct trreply *) nhead.nh_data;

	request->trq_src_node = (nodeid == LOCAL) ? nodeid : getnodeid();
	request->trq_src_event = -getpid();
	request->trq_req = req;
	request->trq_lnum = lnum;
	request->trq_pid = pid;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVTRACED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}
/*
 * Receive total trace length.
 */
	nhead.nh_event = -getpid();
	nhead.nh_type = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	if (nrecv(&nhead)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}

	trtotal = reply->trr_length;
	trleft = reply->trr_length;

	if (trtotal > 0) {
		nhead.nh_msg = malloc((unsigned) MAXNMSGLEN);

		if (nhead.nh_msg == 0) {
			ksigsetmask(mask);
			return(LAMERROR);
		}
	}

	while ((trleft > 0) && (reply->trr_errno == 0)) {
		nhead.nh_type = 0;
		nhead.nh_length = MAXNMSGLEN;

		if (nrecv(&nhead)) {
			free(nhead.nh_msg);
			ksigsetmask(mask);
			return(LAMERROR);
		}

		if (write(fd, nhead.nh_msg, nhead.nh_length) < 0) {
			free(nhead.nh_msg);
			ksigsetmask(mask);
			return(LAMERROR);
		}

		trleft -= nhead.nh_length;
	}

	ksigsetmask(mask);

	if (trtotal > 0) {
		free(nhead.nh_msg);
	}

	if (reply->trr_errno) {
		errno = reply->trr_errno;
		return(LAMERROR);
	} else {
		return(trtotal);
	}
}
