/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	Function:	- gathers message status from a remote bufferd
 *	Accepts:	- target node ID
 *			- buffer status table
 *			- # of table entries
 *			- buffer parameter structure ptr
 *	Returns:	- number of replied descriptors or ERROR
 */

#include <unistd.h>

#include <bfreq.h>
#include <events.h>
#include <ksignal.h>
#include <net.h>
#include <terror.h>
#include <typical.h>

int
rbfstate(node, tbl, tblsize, parms)

int4			node;		/* target node ID */
int			tblsize;	/* buffer status table size */
struct bfstatus		tbl[];		/* buffer status table */
struct bfparms		*parms;		/* buffer parameters */

{
	struct nmsg	nhead;		/* network message desc. */
	struct bfreq	*request;	/* bufferd request */
	struct bfreply	*reply;		/* bufferd reply */
	int4		minsize;	/* # expected elements */
	int4		mask;		/* signal mask */
	int4		totsize;	/* total # replied descs */

	request = (struct bfreq *) nhead.nh_data;
	reply = (struct bfreply *) nhead.nh_data;

	request->bfq_src_node = (node == LOCAL) ? node : getnodeid();
	request->bfq_src_event = -getpid();
	request->bfq_req = BFQSTATE;
	request->bfq_maxtbl = tblsize;

	nhead.nh_node = node;
	nhead.nh_event = EVBUFFERD;
	nhead.nh_type = DLCTL;
	nhead.nh_flags = NOBUF;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}

	nhead.nh_event = -getpid();
	nhead.nh_type = 0;
	nhead.nh_flags = 0;

	if (nrecv(&nhead)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}

	if (reply->bfr_reply) {
		errno = reply->bfr_reply;
		ksigsetmask(mask);
		return(LAMERROR);
	}

	parms->bfp_maxspace = reply->bfr_maxspace;
	parms->bfp_nspace = reply->bfr_nspace;
	totsize = reply->bfr_nbuf;
	minsize = LAM_min(totsize, tblsize);
	nhead.nh_length = MAXNMSGLEN;
	nhead.nh_msg = (char *) tbl;

	while (minsize > 0) {
	
		if (nrecv(&nhead)) {
			ksigsetmask(mask);
			return(LAMERROR);
		}
			
		minsize -= nhead.nh_length / sizeof(struct bfstatus);
		nhead.nh_msg += nhead.nh_length;
	}

	ksigsetmask(mask);
	return(totsize);
}
