/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: ldolinks.c,v 6.2 1999/05/26 21:49:59 kmeyer1 Exp $
 *
 *	Function:	- client functions for dlo link services
 */

#include <stdlib.h>
#include <unistd.h>

#include <dl_inet.h>
#include <events.h>
#include <net.h>
#include <terror.h>
#include <typical.h>

/*
 *	ldogetlinks
 *
 *	Function:	- gets link information from dlo_inet
 *	Accepts:	- # links (value returned)
 *			- link array, malloc'd and filled (value returned)
 */
int
ldogetlinks(ppdol, pndol)

struct dolink		**ppdol;
int4			*pndol;

{
	struct doreq	*pdoq;		/* dlo request */
	struct doreply	*pdor;		/* dlo reply */
	struct nmsg	nhq;		/* request message */

	pdoq = (struct doreq *) nhq.nh_data;
	pdoq->doq_req = DOQGETLINKS;
	pdoq->doq_src_event = -getpid();

	nhq.nh_node = LOCAL;
	nhq.nh_event = EVDL0;
	nhq.nh_type = DLCTL;
	nhq.nh_flags = NOBUF;
	nhq.nh_length = 0;
	nhq.nh_msg = 0;

	if (nsend(&nhq)) return(LAMERROR);

	pdor = (struct doreply *) nhq.nh_data;
	nhq.nh_event = pdoq->doq_src_event;
	nhq.nh_type = 0;
	nhq.nh_flags = 0;

	if (nrecv(&nhq)) return(LAMERROR);

	if (pdor->dor_reply != 0) {
		errno = pdor->dor_reply;
		return(LAMERROR);
	}

	*pndol = pdor->dor_nlinks;

	nhq.nh_type = 0;
	nhq.nh_length = *pndol * sizeof(struct dolink);

	*ppdol = (struct dolink *) malloc((unsigned) nhq.nh_length);
	if (*ppdol == 0) return(LAMERROR);

	nhq.nh_msg = (char *) *ppdol;
	return(nrecv(&nhq));
}

/*
 *	ldosetlink
 *
 *	Function:	- sets link information in dlo_inet
 *	Accepts:	- link information
 */
int
ldosetlink(pdol)

struct dolink		*pdol;

{
	struct doreq	*pdoq;		/* dlo request */
	struct nmsg	nhq;		/* request message */

	pdoq = (struct doreq *) nhq.nh_data;
	pdoq->doq_req = DOQSETLINK;

	nhq.nh_node = LOCAL;
	nhq.nh_event = EVDL0;
	nhq.nh_type = DLCTL;
	nhq.nh_flags = NOBUF;
	nhq.nh_length = sizeof(struct dolink);
	nhq.nh_msg = (char *) pdol;

	return(nsend(&nhq));
}

/*
 *	ldoremlink
 *
 *	Function:	- removes link information in dlo_inet
 *	Accepts:	- link number
 */
int
ldoremlink(link)

int4			link;

{
	struct doreq	*pdoq;		/* dlo request */
	struct nmsg	nhq;		/* request message */

	pdoq = (struct doreq *) nhq.nh_data;
	pdoq->doq_req = DOQREMLINK;
	pdoq->doq_link = link;

	nhq.nh_node = LOCAL;
	nhq.nh_event = EVDL0;
	nhq.nh_type = DLCTL;
	nhq.nh_flags = NOBUF;
	nhq.nh_length = 0;
	nhq.nh_msg = 0;

	return(nsend(&nhq));
}
