/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB/RBD
 *
 *      $Id: rrsetrents.c,v 6.4 1999/09/10 05:22:49 jsquyres Exp $
 *
 *	Function:	- changes route information in router
 */

#include <lam_config.h>

#include <events.h>
#include <net.h>
#include <rreq.h>
#include <typical.h>

/*
 *	rrsetrents
 *
 *	Function:	- adds route information to router
 *	Accepts:	- node
 *			- route entry array
 *			- array size
 */
int
rrsetrents(node, prents, nrents)

int4			node;
struct route		*prents;
int4			nrents;

{
	struct rreq	*prq;		/* router request */
	struct nmsg	nhq;		/* router message */
/*
 * Set up the router request.
 */
	LAM_ZERO_ME(nhq);
	prq = (struct rreq *) nhq.nh_data;
	prq->rq_request = RQSETROUTES;

	nhq.nh_node = node;
	nhq.nh_event = EVROUTER;
	nhq.nh_type = 0;
	nhq.nh_flags = NOBUF;

	while (nrents > 0) {
		prq->rq_nrents = LAM_min(RNRENT, nrents);
		nhq.nh_length = prq->rq_nrents * sizeof(struct route);
		nhq.nh_msg = (char *) prents;

		if (nsend(&nhq)) return(ERROR);

		nrents -= prq->rq_nrents;
		prents += prq->rq_nrents;
	}

	return(0);
}

/*
 *	rremrent
 *
 *	Function:	- removes route information on one node
 *	Accepts:	- router node
 *			- removed node
 */
int
rremrent(node, remnode)

int4			node;
int4			remnode;

{
	struct rreq	*prq;		/* router request */
	struct nmsg	nhq;		/* router message */
/*
 * Set up the router request.
 */
	prq = (struct rreq *) nhq.nh_data;
	prq->rq_request = RQREMROUTE;
	prq->rq_nodeid = remnode;

	nhq.nh_node = node;
	nhq.nh_event = EVROUTER;
	nhq.nh_type = 0;
	nhq.nh_flags = NOBUF;
	nhq.nh_length = 0;
	nhq.nh_msg = 0;

	return(nsend(&nhq));
}
