/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: lamfault.c,v 1.1 2000/05/06 17:34:52 jsquyres Exp $
 *
 *	Function:	- LAM-MPI fault tolerance
 */

#include <all_list.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

/*
 *	lam_commfault
 *
 *	Function:	- invalidate communicators involving a dead node
 *	Accepts:	- dead node's id
 */
void
lam_commfault(node)

int			node;

{
	MPI_Comm	*comm;			/* communicator */
	struct _proc	**p;
	int		i;
	
	comm = al_top(lam_comms);

	for ( ; comm; comm = al_next(lam_comms, comm)) {
/*
 * There is nothing to do if the local group is already dead.
 */
		if ((*comm)->c_flags & LAM_CLDEAD) continue;
/*
 * Check the local group.
 */
		p = (*comm)->c_group->g_procs;
		
		for (i = (*comm)->c_group->g_nprocs; i > 0 ; i--, p++) {

			if ((*p)->p_gps.gps_node == node) {
				(*comm)->c_flags |= LAM_CLDEAD;
				break;
			}
		}
/*
 * If it's an intercommunicator and the remote group is not dead, then
 * check the remote group.
 */
		if (LAM_IS_INTER(*comm) && ! ((*comm)->c_flags & LAM_CRDEAD)) {
			
			p = (*comm)->c_rgroup->g_procs;

			for (i = (*comm)->c_rgroup->g_nprocs; i > 0 ;
					i--, p++) {

				if ((*p)->p_gps.gps_node == node) {
					(*comm)->c_flags |= LAM_CRDEAD;
					break;
				}
			}
		}
	}
}
