/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: mem.c,v 1.1 2000/05/31 03:02:44 jsquyres Exp $
 *
 *	Function:	- default _rpi_c2c_* memory functions; wrappers to 
 *                        malloc and free().
 */

#include <lam_config.h>

#include <mpi.h>
#include <mpisys.h>
#include <stdlib.h>

/*
 *	_rpi_c2c_alloc_mem
 *
 *	Function:	- default alloc_mem function; wrapper to malloc
 *	Accepts:	- size to allocate
 *                      - info arg (ignored here)
 *	Returns:	- ptr to allocated memory
 */
int _rpi_c2c_alloc_mem(MPI_Aint size, MPI_Info info, void *baseptr)
{
  void *ret = malloc(size);
  if (ret == 0)
    return LAMERROR;

  *((void **) baseptr) = ret;

  return MPI_SUCCESS;
}


/*
 *	_rpi_c2c_free_mem
 *
 *	Function:	- default free_mem function; wrapper to free
 *	Accepts:	- ptr to memory to free
 *	Returns:	- MPI_SUCCESS
 */
int _rpi_c2c_free_mem(void *base)
{
  free(base);

  return MPI_SUCCESS;
}


