/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: wtick.c,v 6.4 1999/12/31 21:27:43 jsquyres Exp $
 *
 *	Function:	- return timer resolution
 *	Returns:	- time resolution in seconds
 */

#include <mpi.h>
#include <mpisys.h>
#include <net.h>

/*@
  MPI_Wtick - Returns the resolution of MPI_Wtime

Return value:

Time in seconds of resolution of 'MPI_Wtime'.

Notes for Fortran:

This is function is declared as 'DOUBLE PRECISION MPI_WTICK()' in
Fortran.

.seealso: MPI_Wtime  

.N ACK
@*/
double MPI_Wtick(void)
{
	static double	tick = 0.0;
	double		t;
	int		i;

	if (tick == 0.0) {

		tick = ttime();
		tick = ttime() - tick;
		
		for (i = 0; i < 10; i++) {
			t = ttime();
			t = ttime() - t;

			if (t < tick) {
				tick = t;
			}
		}

		tick = (tick > 0.0) ? tick : 1.0e-6;
	}

	return(tick);
}
