/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: wseterr.c,v 1.1 2001/02/03 20:51:50 arodrig6 Exp $
 *
 *	Function:	- set error handler for window
 *	Accepts:	- communicator
 *			- error handler
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*@
    MPI_Win_set_errhandler - Sets a window error handler

Input Parameters:
errhdl - new error handler for window (handle) 
win - window (handle) 

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_WIN
.N MPI_ERR_ARG

.seealso MPI_Win_create_errhandler(3),  MPI_Win_get_errhandler(3)

.N WEB
@*/

int MPI_Win_set_errhandler(MPI_Win win,MPI_Errhandler errhdl)
{
	int		err;

	lam_initerr_m();
	lam_setfunc_m(BLKMPIWINSETERRHDL);
/*
 * Check the arguments.
 */
	if (win == MPI_WIN_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIWINSETERRHDL, lam_mkerr(MPI_ERR_WIN, 0)));
	}

	if (errhdl == MPI_ERRHANDLER_NULL || !(errhdl->eh_flags & LAM_EHWIN)) {
		return(lam_errfunc(win->w_comm,
			BLKMPIWINSETERRHDL, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Free previous error handler.
 */
	err = MPI_Errhandler_free(&(win->w_errhdl));
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(win->w_comm, BLKMPIWINSETERRHDL, err));
	}
/*
 * Set the communicator's new error handler.
 */
	win->w_errhdl = errhdl;
	errhdl->eh_refcount++;

	lam_resetfunc_m(BLKMPIWINSETERRHDL);
	return(MPI_SUCCESS);
}
