/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: tub.c,v 6.4 1999/12/31 21:27:41 jsquyres Exp $
 *
 *	Function:	- return upper bound of datatype
 *	Accepts:	- datatype
 *			- upper bound (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


/*@
    MPI_Type_ub - Returns the upper bound of a datatype

Input Parameters:
. dtype - datatype (handle) 

Output Parameter:
. ub - displacement of upper bound from origin, 
                             in bytes (integer) 

.N Wrapper MPI_Type_get_extent

.N ACK
@*/
int MPI_Type_ub(MPI_Datatype dtype, MPI_Aint *ub)
{
	lam_initerr();
	lam_setfunc(BLKMPITUB);

	if (dtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITUB, lam_mkerr(MPI_ERR_TYPE, 0)));
	}
	else if (ub == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITUB, lam_mkerr(MPI_ERR_ARG, 0)));
	}
	else {
		*ub = dtype->dt_upper;
	}

	lam_resetfunc(BLKMPITUB);
	return(MPI_SUCCESS);
}
