/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: pcontrol.c,v 6.5 1999/12/31 21:27:35 jsquyres Exp $
 *
 *	Function:	- set profiling control level
 *			- NOP in MPI, up for profiling packages
 *	Accepts:	- level setting
 *			- varargs
 *	Returns:	- MPI_SUCCESS
 */

#include <lam_config.h>
#include <mpi.h>
#include <mpisys.h>

#if LAM_WANT_PROTOS

/*@

MPI_Pcontrol - Controls profiling

Input Parameters:
. level - Profiling level 

Notes:

This routine provides a common interface for profiling control.  The
interpretation of 'level' and any other arguments is left to the
profiling library.  LAM/MPI''s implementation of this function is a
no-op that always returns 'MPI_SUCCESS'.

.N fortran

.N ACK
@*/
int MPI_Pcontrol(int level, ...)
{
	return(MPI_SUCCESS);
}

#else

int
MPI_Pcontrol(level)
int			level;
{
	return(MPI_SUCCESS);
}

#endif
