/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: namepub.c,v 6.5 2001/01/29 15:40:08 jsquyres Exp $
 *
 *	Function:	- publish a port/service pair
 *	Accepts:	- service name
 *			- info
 *			- port name
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <errno.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*@
    MPI_Publish_name - Publish a service name for dynamic process control

Input Parameters:
+ service_name - a service name to associate with the port
. info - implementation-specific information
- port_name - a port name from 'MPI_Open_port'

Notes: 

Currently, LAM/MPI ignores any info keys that are passed to this
function.  As such, info keys specific to a different implementation
can safely be passed to this function.  Additionally, the MPI constant
'MPI_INFO_NULL' can also be used.

The scope of the published name is the LAM universe -- MPI processes
running on any node included from the initial lamboot are capable of
retrieving a name published by 'MPI_Publish_name'.  Service names stay
in existence until they are either manually removed with
'MPI_Unpublish_name' or cleaned with the 'lamclean' command.  It is a
common mistake to forget to 'MPI_Unpublish_name' at the end of a run,
and therefore leave published names in the LAM runtime environment.

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_ARG
.N MPI_ERR_SERVICE

.seealso: MPI_Lookup_name, MPI_Unpublish_name

.N WEB
@*/
int
MPI_Publish_name(char *service_name, MPI_Info info, char *port_name)
{
	lam_initerr();
	lam_setfunc(BLKMPIPUBLISHNAME);
/*
 * Check arguments.
 */
	if (port_name == 0 || service_name == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIPUBLISHNAME,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Publish name.
 */
	if (lam_publish(service_name, port_name)) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIPUBLISHNAME,
				lam_mkerr(MPI_ERR_SERVICE, errno))); 
	}

        lam_resetfunc(BLKMPIPUBLISHNAME);
	return(MPI_SUCCESS);
}
