/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: getaddress.c,v 1.2 2001/01/29 21:43:52 bbarrett Exp $
 *
 *	Function:	- get address of location
 *	Accepts:	- location
 *			- address (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


/*@
   MPI_Get_address - obtain the address of a location in caller memory

Input Parameter:
. loc - location in caller memory

Output Parameter:
. addr - address of location

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_ARG

.seealso MPI_Type_create_hvector(3), MPI_Type_create_hindexed(3), MPI_Type_create_struct(3)

.N WEB
@*/
int
MPI_Get_address(void *loc, MPI_Aint *addr)
{
	lam_initerr_m();
	lam_setfunc_m(BLKMPIGETADDRESS);

	if (addr == 0) {
		return(lam_err_comm(MPI_COMM_WORLD, MPI_ERR_ARG, 0,
			"null pointer"));
	}

	*addr = ((MPI_Aint) loc) - ((MPI_Aint) MPI_BOTTOM);

	lam_resetfunc_m(BLKMPIGETADDRESS);
	return(MPI_SUCCESS);
}
