/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: finalized.c,v 6.1 2000/06/21 23:00:34 jsquyres Exp $
 *
 *	Function:	- check if MPI has been finalized
 *	Accepts:	- result flag (out)
 *	Returns:	- MPI_SUCCESS
 */

#include <mpi.h>
#include <mpisys.h>

/*@
   MPI_Finalized - Indicates whether 'MPI_Finalize' has completed.

Output Parameter:

. flag - Flag is true (1) if 'MPI_Finalize' has been called and false (0)
otherwise.

Notes:

Note that this function does not indicate whether 'MPI_INIT' has been
called.  It only indicates whethere 'MPI_FINALIZE' has been called.

This function always returns 'MPI_SUCCESS'.

.N fortran

.N ACK
@*/
int MPI_Finalized(int *flag)
{
  if (flag)
    *flag = lam_finalized();
  
  return(MPI_SUCCESS);
}
