/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: tcreatestruct_f.c,v 1.1 1999/09/02 01:34:31 prijks Exp $
 *
 *	Function:	- MPI_Type_create_struct F77 wrapper
 */

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>

void
mpi_type_create_struct_(c, b, d, t, nt, ierr)

int			*c, *b, *t, *nt, *ierr;
MPI_Aint		*d;

{
	MPI_Datatype	dtype;
	MPI_Datatype	*tp;
	int		i;

	if (*c > 0) {
		tp = (MPI_Datatype *) malloc((*c) * sizeof(MPI_Datatype));
		if (tp == 0) {
			lam_setfunc(BLKMPITCREATESTRUCT);
			*ierr = lam_errfunc(MPI_COMM_WORLD, BLKMPITCREATESTRUCT,
					lam_mkerr(MPI_ERR_OTHER, errno));
			return;
		}
	} else {
		tp = 0;
	}
	
	for (i = 0; i < *c; ++i) {
		tp[i] = GETHDL(t[i]);
	}

	*ierr = MPI_Type_create_struct(*c, b, d, tp, &dtype);

	if (lam_F_make_hdl(nt, ierr, dtype, BLKMPITCREATESTRUCT)) {
		dtype->dt_f77handle = *nt;
	}

	free((char *) tp);
}
