/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio	State University
 *	NJN
 *
 *	$Id: mpil_spawn_f.c,v 6.4 1999/09/02 01:34:23 prijks Exp $
 *
 *	Function:	- MPIL_Spawn, MPIL_Comm_parent,	MPIL_Universe_size
 *			  F77 wrappers
 */

#include <lam_config.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>


void
mpil_spawn_(c, a, r, ic, ierr)

int	*c, *r,	*ic, *ierr;
char	*a;

{
	MPI_Comm comm;

	*ierr =	MPIL_Spawn(GETHDL(*c), a, *r, &comm);
	
	if (lam_F_make_hdl(ic, ierr, comm, BLKMPILSPAWN)) {
		comm->c_f77handle = *ic;
	}
}


void
mpil_comm_parent_(c, ierr)

int	*c, *ierr;

{
	MPI_Comm	parent;

	*c = -1;
	*ierr = MPIL_Comm_parent(&parent);

	if (*ierr == MPI_SUCCESS && parent != MPI_COMM_NULL) {
		if (parent->c_f77handle < 0) {
			lam_F_make_hdl(c, ierr, parent, BLKMPILCOMMPARENT);
			parent->c_f77handle = *c;
		} else {
			*c = parent->c_f77handle;
		}
	}
}


void 
mpil_universe_size_(s, ierr)

int	*s, *ierr;

{
	*ierr =	MPIL_Universe_size(s);
}
