/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: ccreatekey_f.c,v 1.3 2000/04/06 21:42:12 jsquyres Exp $
 *
 *	Function:	- MPI_Comm_create_keyval F77 wrapper
 */

#include <lam_config.h>

#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>

void
mpi_comm_create_keyval_(cf, df, k, es, ierr)

void	(*cf) ();
void	(*df) ();
int	*k, *es, *ierr;

{
	MPI_Comm_copy_attr_function 	*cf_C;
	MPI_Comm_delete_attr_function 	*df_C;
	struct _attrkey 		*pk;

	if ((cf == mpi_null_copy_fn_ || cf == mpi_comm_null_copy_fn_)) {
	    cf_C = 0;
	}
#if LAM_FORTRANCAPS
/*
 * In this case the C and Fortran are the same. Check against the C function
 * and replace it with a Fortran version if there is a match.
 */
	else if ((void *) cf == (void *) MPI_DUP_FN) {
	    cf_C = (MPI_Comm_copy_attr_function *) MPI_F_DUP_FN;
	}
	else if (cf == (void *) MPI_COMM_DUP_FN) {
	    cf_C = (MPI_Comm_copy_attr_function *) MPI_F_COMM_DUP_FN;
	}
#endif
	else {
	    cf_C =  (MPI_Comm_copy_attr_function *) cf;
	}

	df_C = (df == mpi_null_delete_fn_ || df == mpi_comm_null_delete_fn_)
	    		? 0 : (MPI_Comm_delete_attr_function *) df;

	*ierr =	MPI_Comm_create_keyval(cf_C, df_C, k, 
				       (void *) LAM_INT_TO_VOID_P *es);

	if (*ierr == MPI_SUCCESS) {
		pk = lam_getattr(*k);
		pk->ak_flags |= LAM_LANGF77;
	}
}
